/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.cursor;

import java.util.List;
import java.util.Objects;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.index.cursor.AncestorCursor;
import org.apache.jackrabbit.oak.plugins.index.cursor.ConcatCursor;
import org.apache.jackrabbit.oak.plugins.index.cursor.IntersectionCursor;
import org.apache.jackrabbit.oak.plugins.index.cursor.PathCursor;
import org.apache.jackrabbit.oak.plugins.index.cursor.PrefetchCursor;
import org.apache.jackrabbit.oak.plugins.index.cursor.TraversingCursor;
import org.apache.jackrabbit.oak.query.FilterIterators;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.PrefetchNodeStore;

public class Cursors {
    private Cursors() {
    }

    public static void checkMemoryLimit(long count, QueryLimits settings) {
        FilterIterators.checkMemoryLimit(count, settings);
    }

    public static void checkReadLimit(long count, QueryLimits settings) {
        FilterIterators.checkReadLimit(count, settings);
    }

    public static Cursor newIntersectionCursor(Cursor a, Cursor b, QueryLimits settings) {
        return new IntersectionCursor(a, b, settings);
    }

    public static Cursor newConcatCursor(List<Cursor> cursors, QueryLimits settings) {
        return new ConcatCursor(cursors, settings);
    }

    public static Cursor newPrefetchCursor(Cursor cursor, PrefetchNodeStore store, int prefetchCount, NodeState rootState, List<String> prefetchRelative) {
        return new PrefetchCursor(cursor, store, prefetchCount, rootState, prefetchRelative);
    }

    public static Cursor newPathCursor(Iterable<String> paths, QueryLimits settings) {
        return new PathCursor(paths.iterator(), true, settings);
    }

    public static Cursor newPathCursorDistinct(Iterable<String> paths, QueryLimits settings) {
        return new PathCursor(paths.iterator(), true, settings);
    }

    public static Cursor newTraversingCursor(Filter filter, NodeState rootState) {
        return new TraversingCursor(filter, rootState);
    }

    public static Cursor newAncestorCursor(Cursor c, int level, QueryLimits settings) {
        Objects.requireNonNull(c);
        Validate.checkArgument(level >= 1);
        return new AncestorCursor(c, level, settings);
    }
}

