/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.jackrabbit.oak.plugins.memory.AbstractBlob;
import org.jetbrains.annotations.NotNull;

public class StringBasedBlob
extends AbstractBlob {
    private final String value;

    public StringBasedBlob(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    @NotNull
    public InputStream getNewStream() {
        return new ByteArrayInputStream(this.value.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public long length() {
        return this.value.getBytes(StandardCharsets.UTF_8).length;
    }
}

