/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.name;

import java.util.ArrayList;
import java.util.Collections;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.name.NamespaceRegistryModel;
import org.apache.jackrabbit.oak.plugins.name.Namespaces;
import org.apache.jackrabbit.oak.spi.namespace.NamespaceConstants;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyNamespaceRegistry
implements NamespaceRegistry,
NamespaceConstants {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyNamespaceRegistry.class);
    private static volatile boolean CONSISTENCY_CHECKED;
    protected final Root root;
    protected final Tree namespaces;
    protected final Tree nsdata;

    public ReadOnlyNamespaceRegistry(Root root) {
        this.root = root;
        this.namespaces = root.getTree("/jcr:system/rep:namespaces");
        this.nsdata = this.namespaces.getChild("rep:nsdata");
        if (!CONSISTENCY_CHECKED) {
            this.checkConsistency(root);
            CONSISTENCY_CHECKED = true;
        }
    }

    private Iterable<String> getNSData(String name) {
        PropertyState property = this.nsdata.getProperty(name);
        if (property != null && property.getType() == Type.STRINGS) {
            return property.getValue(Type.STRINGS);
        }
        return Collections.emptyList();
    }

    public void registerNamespace(String prefix, String uri) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void unregisterNamespace(String prefix) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    @NotNull
    public String[] getPrefixes() {
        ArrayList prefixes = new ArrayList();
        this.getNSData("rep:prefixes").forEach(prefixes::add);
        return prefixes.toArray(new String[prefixes.size()]);
    }

    @NotNull
    public String[] getURIs() {
        ArrayList uris = new ArrayList();
        this.getNSData("rep:uris").forEach(uris::add);
        return uris.toArray(new String[uris.size()]);
    }

    @NotNull
    public String getURI(String prefix) throws NamespaceException {
        if (prefix.isEmpty()) {
            return prefix;
        }
        PropertyState property = this.namespaces.getProperty(prefix);
        if (property != null && property.getType() == Type.STRING) {
            return property.getValue(Type.STRING);
        }
        throw new NamespaceException("No namespace registered for prefix " + prefix);
    }

    @NotNull
    public String getPrefix(String uri) throws NamespaceException {
        if (uri.isEmpty()) {
            return uri;
        }
        PropertyState property = this.nsdata.getProperty(Namespaces.encodeUri(uri));
        if (property != null && property.getType() == Type.STRING) {
            return property.getValue(Type.STRING);
        }
        throw new NamespaceException("No namespace prefix registered for URI " + uri);
    }

    public boolean checkConsistency() throws IllegalStateException {
        return this.checkConsistency(this.root);
    }

    public boolean checkConsistency(Root root) throws IllegalStateException {
        NamespaceRegistryModel model = NamespaceRegistryModel.create(root);
        if (model == null) {
            LOG.warn("Consistency check skipped because there is no namespace registry.");
        }
        return model == null || model.isConsistent();
    }
}

