/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.write;

import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.oak.namepath.JcrNameParser;
import org.apache.jackrabbit.oak.namepath.NameMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class NamedTemplate {
    private final NameMapper mapper;
    private String oakName = null;

    protected NamedTemplate(@NotNull NameMapper mapper) {
        this.mapper = mapper;
    }

    protected NamedTemplate(@NotNull NameMapper mapper, @Nullable String jcrName) throws ConstraintViolationException {
        this(mapper);
        if (jcrName != null) {
            this.setName(jcrName);
        }
    }

    @Nullable
    protected String getOakName() {
        return this.oakName;
    }

    @Nullable
    public String getName() {
        return this.getJcrNameAllowNull(this.oakName);
    }

    public void setName(@NotNull String jcrName) throws ConstraintViolationException {
        this.oakName = this.getOakNameOrThrowConstraintViolation(jcrName);
    }

    @Nullable
    protected String getJcrNameAllowNull(@Nullable String oakName) {
        if (oakName != null) {
            return this.mapper.getJcrName(oakName);
        }
        return null;
    }

    @Nullable
    protected String[] getJcrNamesAllowNull(@Nullable String[] oakNames) {
        String[] jcrNames = null;
        if (oakNames != null) {
            jcrNames = new String[oakNames.length];
            for (int i = 0; i < oakNames.length; ++i) {
                jcrNames[i] = this.mapper.getJcrName(oakNames[i]);
            }
        }
        return jcrNames;
    }

    @NotNull
    protected String getOakNameOrThrowConstraintViolation(@Nullable String jcrName) throws ConstraintViolationException {
        if (jcrName == null) {
            throw new ConstraintViolationException("Missing JCR name");
        }
        String oakName = this.mapper.getOakNameOrNull(jcrName);
        if (oakName == null || !JcrNameParser.validate(jcrName)) {
            throw new ConstraintViolationException("Invalid name: " + jcrName);
        }
        return oakName;
    }

    @Nullable
    protected String getOakNameAllowNullOrThrowConstraintViolation(@Nullable String jcrName) throws ConstraintViolationException {
        if (jcrName == null) {
            return null;
        }
        return this.getOakNameOrThrowConstraintViolation(jcrName);
    }

    @NotNull
    protected String[] getOakNamesOrThrowConstraintViolation(@Nullable String[] jcrNames) throws ConstraintViolationException {
        if (jcrNames != null) {
            String[] oakNames = new String[jcrNames.length];
            for (int i = 0; i < jcrNames.length; ++i) {
                oakNames[i] = this.getOakNameOrThrowConstraintViolation(jcrNames[i]);
            }
            return oakNames;
        }
        throw new ConstraintViolationException("Missing JCR names");
    }
}

