/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventFilter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class EventTypeFilter
implements EventFilter {
    private final int eventTypes;

    public EventTypeFilter(int eventTypes) {
        this.eventTypes = eventTypes;
    }

    @Override
    public boolean includeAdd(PropertyState after) {
        return this.includeByEvent(4);
    }

    @Override
    public boolean includeChange(PropertyState before, PropertyState after) {
        return this.includeByEvent(16);
    }

    @Override
    public boolean includeDelete(PropertyState before) {
        return this.includeByEvent(8);
    }

    @Override
    public boolean includeAdd(String name, NodeState after) {
        return this.includeByEvent(1);
    }

    @Override
    public boolean includeDelete(String name, NodeState before) {
        return this.includeByEvent(2);
    }

    @Override
    public boolean includeMove(String sourcePath, String name, NodeState moved) {
        return this.includeByEvent(32);
    }

    @Override
    public boolean includeReorder(String destName, String name, NodeState reordered) {
        return this.includeByEvent(32);
    }

    @Override
    public EventFilter create(String name, NodeState before, NodeState after) {
        return this;
    }

    private boolean includeByEvent(int eventType) {
        return (this.eventTypes & eventType) != 0;
    }
}

