/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import java.util.Set;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.version.ReadWriteVersionManager;
import org.apache.jackrabbit.oak.plugins.version.Utils;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class OrphanedVersionCleaner
extends DefaultEditor {
    private final ReadWriteVersionManager vMgr;
    private final Set<String> existingVersionables;

    OrphanedVersionCleaner(ReadWriteVersionManager vMgr, Set<String> existingVersionables) {
        this.vMgr = vMgr;
        this.existingVersionables = existingVersionables;
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        String versionableUuid;
        if (this.vMgr.isVersionable(before) && !this.vMgr.isVersionable(after) && !this.existingVersionables.contains(versionableUuid = Utils.uuidFromNode(before))) {
            this.vMgr.removeEmptyHistory(before);
        }
    }

    @Override
    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        return this;
    }

    @Override
    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        return this;
    }

    @Override
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        return this;
    }

    static class Provider
    implements EditorProvider {
        private final Set<String> existingVersionables;

        Provider(Set<String> existingVersionables) {
            this.existingVersionables = existingVersionables;
        }

        @Override
        public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) throws CommitFailedException {
            if (!builder.hasChildNode("jcr:system")) {
                return null;
            }
            NodeBuilder system = builder.child("jcr:system");
            if (!system.hasChildNode("jcr:versionStorage")) {
                return null;
            }
            NodeBuilder versionStorage = system.child("jcr:versionStorage");
            ReadWriteVersionManager vMgr = new ReadWriteVersionManager(versionStorage, builder);
            return new OrphanedVersionCleaner(vMgr, this.existingVersionables);
        }
    }
}

