/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.monitor;

import java.util.concurrent.TimeUnit;
import javax.jcr.Credentials;
import javax.management.openmbean.CompositeData;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.oak.spi.security.authentication.ImpersonationCredentials;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginModuleMBean;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginModuleMonitor;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoginModuleMonitorImpl
implements LoginModuleMBean,
LoginModuleMonitor {
    private final StatisticsProvider statisticsProvider;
    static final String LOGIN_ERRORS = "LOGIN_ERRORS";
    private static final String LOGIN_FAILED = "security.authentication.login.failed";
    private static final String LOGIN_TOKEN_FAILED = "security.authentication.login_token.failed";
    private static final String LOGIN_IMPERSONATION_FAILED = "security.authentication.login_impersonation.failed";
    private static final String PRINCIPALS_SIZE = "security.authentication.principals.size";
    private static final String PRINCIPALS_TIMER = "security.authentication.principals.timer";
    private final MeterStats loginErrors;
    private final MeterStats loginFailed;
    private final MeterStats loginTokenFailed;
    private final MeterStats loginImpersonationFailed;
    private final MeterStats principalsSize;
    private final TimerStats principalsTime;

    public LoginModuleMonitorImpl(@NotNull StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
        this.loginErrors = statisticsProvider.getMeter(LOGIN_ERRORS, StatsOptions.DEFAULT);
        this.loginFailed = statisticsProvider.getMeter(LOGIN_FAILED, StatsOptions.DEFAULT);
        this.loginTokenFailed = statisticsProvider.getMeter(LOGIN_TOKEN_FAILED, StatsOptions.DEFAULT);
        this.loginImpersonationFailed = statisticsProvider.getMeter(LOGIN_IMPERSONATION_FAILED, StatsOptions.DEFAULT);
        this.principalsSize = statisticsProvider.getMeter(PRINCIPALS_SIZE, StatsOptions.DEFAULT);
        this.principalsTime = statisticsProvider.getTimer(PRINCIPALS_TIMER, StatsOptions.METRICS_ONLY);
    }

    @Override
    public void loginError() {
        this.loginErrors.mark();
    }

    @Override
    public void loginFailed(@NotNull LoginException loginException, @Nullable Credentials credentials) {
        if (credentials instanceof ImpersonationCredentials) {
            this.loginImpersonationFailed.mark();
        } else if (credentials instanceof TokenCredentials) {
            this.loginTokenFailed.mark();
        } else {
            this.loginFailed.mark();
        }
    }

    @Override
    public void principalsCollected(long timeTakenNanos, int numberOfPrincipals) {
        this.principalsSize.mark(numberOfPrincipals);
        this.principalsTime.update(timeTakenNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getLoginErrors() {
        return this.loginErrors.getCount();
    }

    @Override
    public CompositeData getLoginErrorsHistory() {
        return this.getTimeSeriesData(LOGIN_ERRORS, "Number of login errors.");
    }

    @NotNull
    private CompositeData getTimeSeriesData(@NotNull String name, @NotNull String desc) {
        return TimeSeriesStatsUtil.asCompositeData(this.getTimeSeries(name), desc);
    }

    @NotNull
    private TimeSeries getTimeSeries(@NotNull String name) {
        return this.statisticsProvider.getStats().getTimeSeries(name, true);
    }
}

