/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.query;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.user.Utils;
import org.apache.jackrabbit.oak.security.user.query.Condition;
import org.apache.jackrabbit.oak.security.user.query.ConditionVisitor;
import org.apache.jackrabbit.oak.security.user.query.QueryUtil;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.jetbrains.annotations.NotNull;

class XPathConditionVisitor
implements ConditionVisitor {
    private final StringBuilder statement;
    private final NamePathMapper namePathMapper;
    private final UserManager userMgr;

    XPathConditionVisitor(@NotNull StringBuilder statement, @NotNull NamePathMapper namePathMapper, @NotNull UserManager userMgr) {
        this.statement = statement;
        this.namePathMapper = namePathMapper;
        this.userMgr = userMgr;
    }

    @Override
    public void visit(@NotNull Condition.Node condition) {
        this.statement.append('(').append("jcr:like(@").append(QueryUtil.escapeForQuery("rep:authorizableId", this.namePathMapper)).append(",'").append(QueryUtil.escapeForQuery(condition.getPattern())).append("')").append(" or ").append("jcr:like(@").append(QueryUtil.escapeForQuery("rep:principalName", this.namePathMapper)).append(",'").append(QueryUtil.escapeForQuery(condition.getPattern())).append("')").append(" or ").append("jcr:like(fn:name(),'").append(QueryUtil.escapeForQuery(QueryUtil.escapeNodeName(condition.getPattern()))).append("')").append(')');
    }

    @Override
    public void visit(@NotNull Condition.PropertyValue condition) throws RepositoryException {
        this.statement.append(QueryUtil.escapeForQuery(condition.getRelPath())).append(condition.getOp().getOp()).append(QueryUtil.format(condition.getValue()));
    }

    @Override
    public void visit(@NotNull Condition.PropertyLike condition) {
        this.statement.append("jcr:like(").append(QueryUtil.escapeForQuery(condition.getRelPath())).append(",'").append(QueryUtil.escapeForQuery(condition.getPattern())).append("')");
    }

    @Override
    public void visit(@NotNull Condition.PropertyExists condition) {
        this.statement.append(QueryUtil.escapeForQuery(condition.getRelPath()));
    }

    @Override
    public void visit(@NotNull Condition.Contains condition) {
        this.statement.append("jcr:contains(").append(QueryUtil.escapeForQuery(condition.getRelPath())).append(",'").append(QueryUtil.escapeForQuery(condition.getSearchExpr())).append("')");
    }

    @Override
    public void visit(@NotNull Condition.Impersonation condition) {
        String principalName = condition.getName();
        if (Utils.canImpersonateAllUsers(new PrincipalImpl(principalName), this.userMgr)) {
            this.statement.append('@').append(QueryUtil.escapeForQuery("jcr:primaryType", this.namePathMapper)).append("='").append(QueryUtil.escapeForQuery("rep:User", this.namePathMapper)).append('\'');
        } else {
            this.statement.append('@').append(QueryUtil.escapeForQuery("rep:impersonators", this.namePathMapper)).append("='").append(condition.getName()).append('\'');
        }
    }

    @Override
    public void visit(@NotNull Condition.Not condition) throws RepositoryException {
        this.statement.append("not(");
        condition.getCondition().accept(this);
        this.statement.append(')');
    }

    @Override
    public void visit(@NotNull Condition.And condition) throws RepositoryException {
        int count = 0;
        for (Condition c : condition) {
            this.statement.append(count++ > 0 ? " and " : "");
            c.accept(this);
        }
    }

    @Override
    public void visit(@NotNull Condition.Or condition) throws RepositoryException {
        int pos = this.statement.length();
        int count = 0;
        for (Condition c : condition) {
            this.statement.append(count++ > 0 ? " or " : "");
            c.accept(this);
        }
        if (count > 1) {
            this.statement.insert(pos, '(');
            this.statement.append(')');
        }
    }
}

