/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.principal;

import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface PrincipalProvider {
    @Nullable
    public Principal getPrincipal(@NotNull String var1);

    @Nullable
    default public ItemBasedPrincipal getItemBasedPrincipal(@NotNull String principalOakPath) {
        return null;
    }

    @NotNull
    default public Set<Principal> getMembershipPrincipals(@NotNull Principal principal) {
        return Collections.emptySet();
    }

    @NotNull
    public Set<? extends Principal> getPrincipals(@NotNull String var1);

    @NotNull
    public Iterator<? extends Principal> findPrincipals(@Nullable String var1, int var2);

    @NotNull
    default public Iterator<? extends Principal> findPrincipals(@Nullable String nameHint, boolean fullText, int searchType, long offset, long limit) {
        if (offset < 0L) {
            throw new IllegalArgumentException(Long.toString(offset));
        }
        Iterator<? extends Principal> principals = this.findPrincipals(nameHint, searchType);
        Spliterator<? extends Principal> spliterator = Spliterators.spliteratorUnknownSize(principals, 0);
        Stream<? extends Principal> stream = StreamSupport.stream(spliterator, false);
        if (offset > 0L) {
            stream = stream.skip(offset);
        }
        if (limit >= 0L) {
            stream = stream.limit(limit);
        }
        return stream.iterator();
    }

    @NotNull
    public Iterator<? extends Principal> findPrincipals(int var1);
}

