/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.apache.sling.testing.mock.sling.MockResourceBundle;
import org.apache.sling.testing.mock.sling.MockResourceBundleProvider;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class MockResourceBundleProviderTest {
    private static final String MY_NAME = "my-name";
    @Rule
    public SlingContext context = new SlingContext();

    @Test
    public void testGetResourceBundleFromRequest() {
        ResourceBundle bundle = this.context.jakartaRequest().getResourceBundle(Locale.CANADA_FRENCH);
        Assert.assertEquals((Object)Locale.CANADA_FRENCH, (Object)bundle.getLocale());
        Assert.assertNull((Object)((MockResourceBundle)bundle).getBaseName());
    }

    @Test
    public void testGetResourceBundleFromRequestWithBaseName() {
        ResourceBundle bundle = this.context.jakartaRequest().getResourceBundle(MY_NAME, Locale.CANADA_FRENCH);
        Assert.assertEquals((Object)Locale.CANADA_FRENCH, (Object)bundle.getLocale());
        Assert.assertEquals((Object)MY_NAME, (Object)((MockResourceBundle)bundle).getBaseName());
    }

    @Test
    public void testDefaultLocale() {
        MockResourceBundleProvider bundleProvider = (MockResourceBundleProvider)this.context.getService(ResourceBundleProvider.class);
        Assert.assertNotNull((Object)bundleProvider);
        bundleProvider.setDefaultLocale(Locale.KOREA);
        ResourceBundle bundle = this.context.jakartaRequest().getResourceBundle(null);
        Assert.assertEquals((Object)Locale.KOREA, (Object)bundle.getLocale());
        Assert.assertNull((Object)((MockResourceBundle)bundle).getBaseName());
    }

    @Test
    public void testCaching() {
        ResourceBundle bundle = this.context.jakartaRequest().getResourceBundle(Locale.GERMAN);
        ((MockResourceBundle)bundle).put("key1", "value1");
        Assert.assertEquals((Object)"value1", (Object)bundle.getString("key1"));
        ResourceBundle bundle_cached = this.context.jakartaRequest().getResourceBundle(Locale.GERMAN);
        Assert.assertEquals((Object)"value1", (Object)bundle_cached.getString("key1"));
        ResourceBundle bundle_otherlocale = this.context.jakartaRequest().getResourceBundle(Locale.FRANCE);
        Assert.assertEquals((Object)"key1", (Object)bundle_otherlocale.getString("key1"));
        ResourceBundle bundle_otherbasename = this.context.jakartaRequest().getResourceBundle(MY_NAME, Locale.GERMAN);
        Assert.assertEquals((Object)"key1", (Object)bundle_otherbasename.getString("key1"));
    }
}

