/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

import java.util.Map;
import java.util.Set;
import org.owasp.esapi.codecs.AbstractCharacterCodec;
import org.owasp.esapi.codecs.HashTrie;
import org.owasp.esapi.codecs.PushbackSequence;
import org.owasp.esapi.util.CollectionsUtil;

public class XMLEntityCodec
extends AbstractCharacterCodec {
    private static final String ALPHA_NUMERIC_STR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final String UNENCODED_STR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 \t";
    private static final Set<Character> UNENCODED_SET = CollectionsUtil.strToUnmodifiableSet("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 \t");
    private static final HashTrie<Character> entityToCharacterMap = new HashTrie();

    @Override
    public String encodeCharacter(char[] immune, Character c) {
        if (this.containsCharacter(c.charValue(), immune)) {
            return c.toString();
        }
        if (UNENCODED_SET.contains(c)) {
            return c.toString();
        }
        return "&#x" + Integer.toHexString(c.charValue()) + ";";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Character decodeCharacter(PushbackSequence<Character> input) {
        Character ret = null;
        input.mark();
        try {
            Character first = input.next();
            if (first == null) {
                Character c = null;
                return c;
            }
            if (first.charValue() != '&') {
                Character c = null;
                return c;
            }
            Character second = input.next();
            if (second == null) {
                Character c = null;
                return c;
            }
            if (second.charValue() == '#') {
                ret = XMLEntityCodec.getNumericEntity(input);
            } else if (Character.isLetter(second.charValue())) {
                input.pushback(second);
                ret = this.getNamedEntity(input);
            }
        }
        finally {
            if (ret == null) {
                input.reset();
            }
        }
        return ret;
    }

    private static Character getNumericEntity(PushbackSequence<Character> input) {
        Character first = input.peek();
        if (first == null) {
            return null;
        }
        if (first.charValue() == 'x' || first.charValue() == 'X') {
            input.next();
            return XMLEntityCodec.parseHex(input);
        }
        return XMLEntityCodec.parseNumber(input);
    }

    private static Character int2char(int i) {
        if (!Character.isValidCodePoint(i)) {
            return null;
        }
        if (0 > i || i > 65535) {
            return null;
        }
        return Character.valueOf((char)i);
    }

    private static Character parseNumber(PushbackSequence<Character> input) {
        Character c;
        StringBuilder sb = new StringBuilder();
        while ((c = input.next()) != null && c.charValue() != ';') {
            if (!Character.isDigit(c.charValue())) {
                return null;
            }
            sb.append(c);
        }
        if (c == null) {
            return null;
        }
        if (sb.length() <= 0) {
            return null;
        }
        try {
            return XMLEntityCodec.int2char(Integer.parseInt(sb.toString()));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Character parseHex(PushbackSequence<Character> input) {
        Character c;
        StringBuilder sb = new StringBuilder();
        block6: while ((c = input.next()) != null) {
            switch (c.charValue()) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    sb.append(c);
                    continue block6;
                }
                case ';': {
                    break block6;
                }
                default: {
                    return null;
                }
            }
        }
        if (c == null) {
            return null;
        }
        if (sb.length() <= 0) {
            return null;
        }
        try {
            return XMLEntityCodec.int2char(Integer.parseInt(sb.toString(), 16));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Character getNamedEntity(PushbackSequence<Character> input) {
        int i;
        StringBuilder possible = new StringBuilder();
        int len = Math.min(input.remainder().length(), entityToCharacterMap.getMaxKeyLength() + 1);
        for (i = 0; i < len; ++i) {
            possible.append(Character.toLowerCase(input.next().charValue()));
        }
        Map.Entry<CharSequence, Character> entry = entityToCharacterMap.getLongestMatch(possible);
        if (entry == null) {
            return null;
        }
        len = entry.getKey().length();
        if (possible.length() <= len || possible.charAt(len) != ';') {
            return null;
        }
        input.reset();
        input.next();
        for (i = 0; i < len; ++i) {
            input.next();
        }
        input.next();
        return entry.getValue();
    }

    static {
        entityToCharacterMap.put("lt", Character.valueOf('<'));
        entityToCharacterMap.put("gt", Character.valueOf('>'));
        entityToCharacterMap.put("amp", Character.valueOf('&'));
        entityToCharacterMap.put("apos", Character.valueOf('\''));
        entityToCharacterMap.put("quot", Character.valueOf('\"'));
    }
}

