/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.util.Date;
import java.util.HashMap;
import java.util.Stack;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.IntrusionDetector;
import org.owasp.esapi.Logger;
import org.owasp.esapi.SecurityConfiguration;
import org.owasp.esapi.User;
import org.owasp.esapi.errors.EnterpriseSecurityException;
import org.owasp.esapi.errors.IntrusionException;

public class DefaultIntrusionDetector
implements IntrusionDetector {
    private final Logger logger = ESAPI.getLogger("IntrusionDetector");

    @Override
    public void addException(Exception e) {
        if (ESAPI.securityConfiguration().getDisableIntrusionDetection()) {
            return;
        }
        if (e instanceof EnterpriseSecurityException) {
            this.logger.warning(Logger.SECURITY_FAILURE, ((EnterpriseSecurityException)e).getLogMessage(), e);
        } else {
            this.logger.warning(Logger.SECURITY_FAILURE, e.getMessage(), e);
        }
        User user = ESAPI.authenticator().getCurrentUser();
        String eventName = e.getClass().getName();
        if (e instanceof IntrusionException) {
            return;
        }
        try {
            this.addSecurityEvent(user, eventName);
        }
        catch (IntrusionException ex) {
            SecurityConfiguration.Threshold quota = ESAPI.securityConfiguration().getQuota(eventName);
            for (String action : quota.actions) {
                String message = "User exceeded quota of " + quota.count + " per " + quota.interval + " seconds for event " + eventName + ". Taking actions " + quota.actions;
                this.takeSecurityAction(action, message);
            }
        }
    }

    @Override
    public void addEvent(String eventName, String logMessage) throws IntrusionException {
        if (ESAPI.securityConfiguration().getDisableIntrusionDetection()) {
            return;
        }
        this.logger.warning(Logger.SECURITY_FAILURE, "Security event " + eventName + " received : " + logMessage);
        User user = ESAPI.authenticator().getCurrentUser();
        try {
            this.addSecurityEvent(user, "event." + eventName);
        }
        catch (IntrusionException ex) {
            SecurityConfiguration.Threshold quota = ESAPI.securityConfiguration().getQuota("event." + eventName);
            for (String action : quota.actions) {
                String message = "User exceeded quota of " + quota.count + " per " + quota.interval + " seconds for event " + eventName + ". Taking actions " + quota.actions;
                this.takeSecurityAction(action, message);
            }
        }
    }

    private void takeSecurityAction(String action, String message) {
        User user;
        if (ESAPI.securityConfiguration().getDisableIntrusionDetection()) {
            return;
        }
        if (action.equals("log")) {
            this.logger.fatal(Logger.SECURITY_FAILURE, "INTRUSION - " + message);
        }
        if ((user = ESAPI.authenticator().getCurrentUser()) == User.ANONYMOUS) {
            return;
        }
        if (action.equals("disable")) {
            user.disable();
        }
        if (action.equals("logout")) {
            user.logout();
        }
    }

    private void addSecurityEvent(User user, String eventName) {
        if (ESAPI.securityConfiguration().getDisableIntrusionDetection()) {
            return;
        }
        if (user.isAnonymous()) {
            return;
        }
        HashMap eventMap = user.getEventMap();
        SecurityConfiguration.Threshold threshold = ESAPI.securityConfiguration().getQuota(eventName);
        if (threshold != null) {
            Event event = (Event)eventMap.get(eventName);
            if (event == null) {
                event = new Event(eventName);
                eventMap.put(eventName, event);
            }
            event.increment(threshold.count, threshold.interval);
        }
    }

    private static class Event {
        public String key;
        public Stack times = new Stack();

        public Event(String key) {
            this.key = key;
        }

        public void increment(int count, long interval) throws IntrusionException {
            if (ESAPI.securityConfiguration().getDisableIntrusionDetection()) {
                return;
            }
            Date now = new Date();
            this.times.add(0, now);
            while (this.times.size() > count) {
                this.times.remove(this.times.size() - 1);
            }
            if (this.times.size() == count) {
                Date past = (Date)this.times.get(count - 1);
                long plong = past.getTime();
                long nlong = now.getTime();
                if (nlong - plong < interval * 1000L) {
                    throw new IntrusionException("Threshold exceeded", "Exceeded threshold for " + this.key);
                }
            }
        }
    }
}

