/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.waf.configuration;

import java.util.ArrayList;
import java.util.List;
import org.owasp.esapi.waf.rules.Rule;

public class AppGuardianConfiguration {
    public static final int LOG = 0;
    public static final int REDIRECT = 1;
    public static final int BLOCK = 2;
    public static final int OPERATOR_EQ = 0;
    public static final int OPERATOR_CONTAINS = 1;
    public static final int OPERATOR_IN_LIST = 2;
    public static final int OPERATOR_EXISTS = 3;
    public static int DEFAULT_FAIL_ACTION = 0;
    public static String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    public static String DEFAULT_CONTENT_TYPE = "text/html; charset=" + DEFAULT_CHARACTER_ENCODING;
    public static final String JAVASCRIPT_TARGET_TOKEN = "##1##";
    public static final String JAVASCRIPT_REDIRECT = "<html><body><script>document.location='##1##';</script></body></html>";
    private String defaultErrorPage;
    private int defaultResponseCode;
    private boolean forceHttpOnlyFlagToSession = false;
    private boolean forceSecureFlagToSession = false;
    private String sessionCookieName;
    private List<Rule> beforeBodyRules = new ArrayList<Rule>();
    private List<Rule> afterBodyRules = new ArrayList<Rule>();
    private List<Rule> beforeResponseRules = new ArrayList<Rule>();
    private List<Rule> cookieRules = new ArrayList<Rule>();

    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    public void setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
    }

    public String getDefaultErrorPage() {
        return this.defaultErrorPage;
    }

    public void setDefaultErrorPage(String defaultErrorPage) {
        this.defaultErrorPage = defaultErrorPage;
    }

    public int getDefaultResponseCode() {
        return this.defaultResponseCode;
    }

    public void setDefaultResponseCode(int defaultResponseCode) {
        this.defaultResponseCode = defaultResponseCode;
    }

    public List<Rule> getBeforeBodyRules() {
        return this.beforeBodyRules;
    }

    public List<Rule> getAfterBodyRules() {
        return this.afterBodyRules;
    }

    public List<Rule> getBeforeResponseRules() {
        return this.beforeResponseRules;
    }

    public List<Rule> getCookieRules() {
        return this.cookieRules;
    }

    public void addBeforeBodyRule(Rule r) {
        this.beforeBodyRules.add(r);
    }

    public void addAfterBodyRule(Rule r) {
        this.afterBodyRules.add(r);
    }

    public void addBeforeResponseRule(Rule r) {
        this.beforeResponseRules.add(r);
    }

    public void addCookieRule(Rule r) {
        this.cookieRules.add(r);
    }

    public void setApplyHTTPOnlyFlagToSessionCookie(boolean shouldApply) {
        this.forceHttpOnlyFlagToSession = shouldApply;
    }

    public void setApplySecureFlagToSessionCookie(boolean shouldApply) {
        this.forceSecureFlagToSession = shouldApply;
    }

    public boolean isUsingHttpOnlyFlagOnSessionCookie() {
        return this.forceHttpOnlyFlagToSession;
    }

    public boolean isUsingSecureFlagOnSessionCookie() {
        return this.forceSecureFlagToSession;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WAF Configuration\n");
        sb.append("Before body rules:\n");
        for (Rule rule : this.beforeBodyRules) {
            sb.append("  " + rule.toString() + "\n");
        }
        sb.append("After body rules:\n");
        for (Rule rule : this.afterBodyRules) {
            sb.append("  " + rule.toString() + "\n");
        }
        sb.append("Before response rules:\n");
        for (Rule rule : this.beforeResponseRules) {
            sb.append("  " + rule.toString() + "\n");
        }
        sb.append("Cookie rules:\n");
        for (Rule rule : this.cookieRules) {
            sb.append("  " + rule.toString() + "\n");
        }
        return sb.toString();
    }
}

