/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.ValidateWithMethod;
import net.sf.oval.context.OValContext;
import net.sf.oval.exception.InvalidConfigurationException;
import net.sf.oval.exception.ReflectionException;
import net.sf.oval.internal.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateWithMethodCheck
extends AbstractAnnotationCheck<ValidateWithMethod> {
    private static final long serialVersionUID = 1L;
    private final Map<Class<?>, Method> validationMethodsByClass = new WeakHashMap();
    private boolean ignoreIfNull;
    private String methodName;
    private Class<?> parameterType;

    @Override
    public void configure(ValidateWithMethod constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMethodName(constraintAnnotation.methodName());
        this.setParameterType(constraintAnnotation.parameterType());
        this.setIgnoreIfNull(constraintAnnotation.ignoreIfNull());
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(4);
        messageVariables.put("ignoreIfNull", Boolean.toString(this.ignoreIfNull));
        messageVariables.put("methodName", this.methodName);
        messageVariables.put("parameterType", this.parameterType.getName());
        return messageVariables;
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?> getParameterType() {
        return this.parameterType;
    }

    public boolean isIgnoreIfNull() {
        return this.ignoreIfNull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) throws ReflectionException {
        Method method;
        if (valueToValidate == null && this.ignoreIfNull) {
            return true;
        }
        Class<?> clazz = validatedObject.getClass();
        Map<Class<?>, Method> map = this.validationMethodsByClass;
        synchronized (map) {
            method = this.validationMethodsByClass.get(clazz);
            if (method == null) {
                method = ReflectionUtils.getMethodRecursive(clazz, this.methodName, this.parameterType);
                this.validationMethodsByClass.put(clazz, method);
            }
        }
        if (method == null) {
            throw new InvalidConfigurationException("Method " + clazz.getName() + "." + this.methodName + "(" + this.parameterType + ") not found. Is [" + this.parameterType + "] the correct value for [@ValidateWithMethod.parameterType]?");
        }
        return (Boolean)ReflectionUtils.invokeMethod(method, validatedObject, valueToValidate);
    }

    public void setIgnoreIfNull(boolean ignoreIfNull) {
        this.ignoreIfNull = ignoreIfNull;
        this.requireMessageVariablesRecreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMethodName(String methodName) {
        this.methodName = methodName;
        Map<Class<?>, Method> map = this.validationMethodsByClass;
        synchronized (map) {
            this.validationMethodsByClass.clear();
        }
        this.requireMessageVariablesRecreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterType(Class<?> parameterType) {
        this.parameterType = parameterType;
        Map<Class<?>, Method> map = this.validationMethodsByClass;
        synchronized (map) {
            this.validationMethodsByClass.clear();
        }
        this.requireMessageVariablesRecreation();
    }
}

