/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import java.util.ArrayList;
import java.util.Map;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.expression.AbstractExpressionLanguage;
import net.sf.oval.internal.Log;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionLanguageJRubyImpl
extends AbstractExpressionLanguage {
    private static final Log LOG = Log.getLog(ExpressionLanguageJRubyImpl.class);

    @Override
    public Object evaluate(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        LOG.debug("Evaluating JRuby expression: {1}", expression);
        try {
            RubyInstanceConfig config = new RubyInstanceConfig();
            config.setCompatVersion(CompatVersion.RUBY1_9);
            Ruby runtime = JavaEmbedUtils.initialize(new ArrayList(), (RubyInstanceConfig)config);
            StringBuilder localVars = new StringBuilder();
            for (Map.Entry<String, ?> entry : values.entrySet()) {
                runtime.getGlobalVariables().set("$" + entry.getKey(), JavaEmbedUtils.javaToRuby((Ruby)runtime, entry.getValue()));
                localVars.append(entry.getKey()).append("=$").append(entry.getKey()).append("\n");
            }
            IRubyObject result = runtime.evalScriptlet(localVars + expression);
            return JavaEmbedUtils.rubyToJava((Ruby)runtime, (IRubyObject)result, Object.class);
        }
        catch (RuntimeException ex) {
            throw new ExpressionEvaluationException("Evaluating JRuby expression failed: " + expression, ex);
        }
    }
}

