/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.collection;

import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import org.apache.tiles.request.attribute.HasRemovableKeys;
import org.apache.tiles.request.collection.CollectionUtil;
import org.apache.tiles.request.collection.KeySet;

public class RemovableKeySet
extends KeySet {
    private HasRemovableKeys<?> request;

    public RemovableKeySet(HasRemovableKeys<?> request) {
        super(request);
        this.request = request;
    }

    @Override
    public boolean remove(Object o) {
        String skey = CollectionUtil.key(o);
        Object previous = this.request.getValue(skey);
        if (previous != null) {
            this.request.removeValue(skey);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Collection<?> realCollection = c;
        boolean retValue = false;
        for (String entry : realCollection) {
            retValue |= this.remove(entry);
        }
        return retValue;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Collection<?> realCollection = c;
        boolean retValue = false;
        LinkedHashSet<String> keysToRemove = new LinkedHashSet<String>();
        Enumeration<String> keys = this.request.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (realCollection.contains(key)) continue;
            retValue = true;
            keysToRemove.add(key);
        }
        for (String key : keysToRemove) {
            this.request.removeValue(key);
        }
        return retValue;
    }
}

