/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.render;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.render.CannotRenderException;
import org.apache.tiles.request.render.Renderer;

public class PublisherRenderer
implements Renderer {
    private final Renderer renderer;
    private final List<RendererListener> listeners = new ArrayList<RendererListener>();
    private final List<RendererListener> listenersReversed = new ArrayList<RendererListener>();

    public PublisherRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(String path, Request request) throws IOException {
        if (path == null) {
            throw new CannotRenderException("Cannot dispatch a null path");
        }
        try {
            for (RendererListener listener : this.listeners) {
                listener.start(path, request);
            }
            this.renderer.render(path, request);
        }
        catch (IOException ex) {
            this.handleIOException(ex, request);
        }
        finally {
            for (RendererListener wrapper : this.listenersReversed) {
                wrapper.end(path, request);
            }
        }
    }

    @Override
    public boolean isRenderable(String path, Request request) {
        return this.renderer.isRenderable(path, request);
    }

    public void addListener(RendererListener listener) {
        this.listeners.add(listener);
        this.listenersReversed.clear();
        this.listenersReversed.addAll(this.listeners);
        Collections.reverse(this.listenersReversed);
    }

    private void handleIOException(IOException exception, Request request) throws IOException {
        IOException ex = exception;
        boolean throwIt = this.listeners.isEmpty();
        for (RendererListener listener : this.listenersReversed) {
            try {
                listener.handleIOException(ex, request);
                throwIt = false;
            }
            catch (IOException newEx) {
                ex = newEx;
                throwIt = true;
            }
        }
        if (throwIt) {
            throw ex;
        }
    }

    public static interface RendererListener {
        public void start(String var1, Request var2) throws IOException;

        public void end(String var1, Request var2) throws IOException;

        public void handleIOException(IOException var1, Request var2) throws IOException;
    }
}

