/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor.csp;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.SecureRandom;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.interceptor.csp.CspNonceSource;
import org.apache.struts2.interceptor.csp.CspSettings;

public class DefaultCspSettings
implements CspSettings {
    private static final Logger LOG = LogManager.getLogger(DefaultCspSettings.class);
    private static final String NONCE_KEY = "nonce";
    private final SecureRandom sRand = new SecureRandom();
    private CspNonceSource nonceSource = CspNonceSource.SESSION;
    protected String reportUri;
    protected String reportTo;
    protected String cspHeader = "Content-Security-Policy-Report-Only";

    @Inject(value="struts.csp.nonce.source", required=false)
    public void setNonceSource(String nonceSource) {
        this.nonceSource = StringUtils.isBlank((CharSequence)nonceSource) ? CspNonceSource.SESSION : CspNonceSource.valueOf(nonceSource.toUpperCase());
    }

    @Override
    public void addCspHeaders(HttpServletRequest request, HttpServletResponse response) {
        if (this.nonceSource == CspNonceSource.SESSION) {
            this.addCspHeadersWithSession(request, response);
        } else if (this.nonceSource == CspNonceSource.REQUEST) {
            this.addCspHeadersWithRequest(request, response);
        } else {
            LOG.warn("Unknown nonce source: {}, ignoring CSP settings", (Object)this.nonceSource);
        }
    }

    private void addCspHeadersWithSession(HttpServletRequest request, HttpServletResponse response) {
        if (this.isSessionActive(request)) {
            LOG.trace("Session is active, applying CSP settings");
            String nonceValue = this.generateNonceValue();
            request.getSession().setAttribute(NONCE_KEY, (Object)nonceValue);
            response.setHeader(this.cspHeader, this.createPolicyFormat(nonceValue));
        } else {
            LOG.debug("Session is not active, ignoring CSP settings");
        }
    }

    private void addCspHeadersWithRequest(HttpServletRequest request, HttpServletResponse response) {
        String nonceValue = this.generateNonceValue();
        request.setAttribute(NONCE_KEY, (Object)nonceValue);
        response.setHeader(this.cspHeader, this.createPolicyFormat(nonceValue));
    }

    private boolean isSessionActive(HttpServletRequest request) {
        return request.getSession(false) != null;
    }

    private String generateNonceValue() {
        return Base64.getUrlEncoder().encodeToString(this.getRandomBytes());
    }

    protected String createPolicyFormat(String nonceValue) {
        StringBuilder builder = new StringBuilder().append("object-src").append(String.format(" '%s'; ", "none")).append("script-src").append(String.format(" 'nonce-%s' ", nonceValue)).append(String.format("'%s' ", "strict-dynamic")).append(String.format("%s %s; ", "http:", "https:")).append("base-uri").append(String.format(" '%s'; ", "none"));
        if (this.reportUri != null) {
            builder.append("report-uri").append(String.format(" %s; ", this.reportUri));
            if (this.reportTo != null) {
                builder.append("report-to").append(String.format(" %s; ", this.reportTo));
            }
        }
        return builder.toString();
    }

    private byte[] getRandomBytes() {
        byte[] ret = new byte[18];
        this.sRand.nextBytes(ret);
        return ret;
    }

    @Override
    public void setEnforcingMode(boolean enforcingMode) {
        if (enforcingMode) {
            this.cspHeader = "Content-Security-Policy";
        }
    }

    @Override
    public void setReportUri(String reportUri) {
        this.reportUri = reportUri;
    }

    @Override
    public void setReportTo(String reportTo) {
        this.reportTo = reportTo;
    }

    public String toString() {
        return "DefaultCspSettings{reportUri='" + this.reportUri + "', reportTo='" + this.reportTo + "', cspHeader='" + this.cspHeader + "'}";
    }
}

