/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.profile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.claims.mapping.OidcAttributeToScopeClaimMapper;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.profile.DefaultOAuth20UserProfileDataCreator;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class OidcUserProfileDataCreator
extends DefaultOAuth20UserProfileDataCreator<OidcConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcUserProfileDataCreator.class);

    public OidcUserProfileDataCreator(ObjectProvider<OidcConfigurationContext> configurationContext) {
        super(configurationContext);
    }

    protected Map<String, List<Object>> collectAttributes(Principal principal, RegisteredService registeredService) {
        HashMap<String, List<Object>> attributes = new HashMap<String, List<Object>>();
        OidcAttributeToScopeClaimMapper mapper = ((OidcConfigurationContext)((Object)this.getConfigurationContext().getObject())).getAttributeToScopeClaimMapper();
        super.collectAttributes(principal, registeredService).forEach((key, value) -> {
            List collectionValues = mapper.mapClaim(key, registeredService, principal, value);
            attributes.put((String)key, collectionValues);
        });
        return attributes;
    }

    protected void finalizeProfileResponse(OAuth20AccessToken accessToken, Map<String, Object> modelAttributes, Principal principal, RegisteredService registeredService) {
        super.finalizeProfileResponse(accessToken, modelAttributes, principal, registeredService);
        if (registeredService instanceof OidcRegisteredService) {
            if (accessToken.getClaims().isEmpty()) {
                modelAttributes.put("auth_time", accessToken.getTicketGrantingTicket().getAuthentication().getAuthenticationDate().toEpochSecond());
            } else {
                modelAttributes.keySet().retainAll(CollectionUtils.wrapList((Object[])new String[]{"attributes"}));
            }
        }
        if (!modelAttributes.containsKey("sub")) {
            modelAttributes.put("sub", principal.getId());
        }
        LOGGER.trace("Finalized user profile data as [{}] for access token [{}]", modelAttributes, (Object)accessToken.getId());
    }
}

