/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.api;

import com.datical.liquibase.ext.rules.api.Rule;
import com.datical.liquibase.ext.rules.core.RuleProxy;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class Rules
implements Iterable<Rule> {
    private Set<Rule> rules = new TreeSet<Rule>();

    public Rules(Set<Rule> set) {
        this.rules = new TreeSet<Rule>(set);
    }

    public Rules(Rule ... ruleArray) {
        Collections.addAll(this.rules, ruleArray);
    }

    public Rules(Object ... objectArray) {
        this.register(objectArray);
    }

    public void register(Object ... objectArray) {
        Objects.requireNonNull(objectArray);
        for (Object object : objectArray) {
            Objects.requireNonNull(object);
            this.rules.add(RuleProxy.asRule(object));
        }
    }

    public void unregister(Object ... objectArray) {
        Objects.requireNonNull(objectArray);
        for (Object object : objectArray) {
            Objects.requireNonNull(object);
            this.rules.remove(RuleProxy.asRule(object));
        }
    }

    public void unregister(String object) {
        Objects.requireNonNull(object);
        object = this.findRuleByName((String)object);
        if (object != null) {
            this.unregister(object);
        }
    }

    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    public void clear() {
        this.rules.clear();
    }

    public int size() {
        return this.rules.size();
    }

    @Override
    public Iterator<Rule> iterator() {
        return this.rules.iterator();
    }

    private Rule findRuleByName(String string) {
        return this.rules.stream().filter(rule -> rule.getName().equalsIgnoreCase(string)).findFirst().orElse(null);
    }
}

