/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntity;
import org.flowable.eventregistry.impl.util.CommandContextUtil;

public class SetDeploymentParentDeploymentIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String newParentDeploymentId;

    public SetDeploymentParentDeploymentIdCmd(String deploymentId, String newParentDeploymentId) {
        this.deploymentId = deploymentId;
        this.newParentDeploymentId = newParentDeploymentId;
    }

    public Void execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new FlowableIllegalArgumentException("deploymentId is null");
        }
        EventDeploymentEntity deployment = (EventDeploymentEntity)CommandContextUtil.getDeploymentEntityManager(commandContext).findById(this.deploymentId);
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find deployment with id " + this.deploymentId);
        }
        deployment.setParentDeploymentId(this.newParentDeploymentId);
        CommandContextUtil.getDeploymentEntityManager(commandContext).update(deployment);
        return null;
    }
}

