/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ModelEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class SaveModelCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected ModelEntity model;

    public SaveModelCmd(ModelEntity model) {
        this.model = model;
    }

    public Void execute(CommandContext commandContext) {
        if (this.model == null) {
            throw new FlowableIllegalArgumentException("model is null");
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        if (this.model.getId() == null) {
            processEngineConfiguration.getModelEntityManager().insert(this.model);
        } else {
            processEngineConfiguration.getModelEntityManager().updateModel(this.model);
        }
        return null;
    }
}

