/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.ArrayList;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionList;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class CasCaptchaWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public CasCaptchaWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            this.createInitialRecaptchaEnabledAction(flow);
            this.createValidateRecaptchaAction(flow);
        }
    }

    private void createValidateRecaptchaAction(Flow flow) {
        ActionState state = (ActionState)this.getState(flow, "realSubmit", ActionState.class);
        ActionList actionList = state.getActionList();
        ArrayList<Action> currentActions = new ArrayList<Action>(actionList.size());
        actionList.forEach(currentActions::add);
        currentActions.forEach(arg_0 -> ((ActionList)actionList).remove(arg_0));
        actionList.add((Action)this.createEvaluateAction("validateCaptchaAction"));
        currentActions.forEach(arg_0 -> ((ActionList)actionList).add(arg_0));
        state.getTransitionSet().add(this.createTransition("captchaError", "initializeLoginForm"));
    }

    private void createInitialRecaptchaEnabledAction(Flow flow) {
        flow.getStartActionList().add((Action)this.createEvaluateAction("initializeCaptchaAction"));
    }
}

