/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import java.util.Collection;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManager;

public class ResetExpiredJobsCmd
implements Command<Void> {
    protected Collection<String> jobIds;
    protected JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager;
    protected JobServiceConfiguration jobServiceConfiguration;

    public ResetExpiredJobsCmd(Collection<String> jobsIds, JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager, JobServiceConfiguration jobServiceConfiguration) {
        this.jobIds = jobsIds;
        this.jobEntityManager = jobEntityManager;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Void execute(CommandContext commandContext) {
        for (String jobId : this.jobIds) {
            JobInfoEntity job = (JobInfoEntity)this.jobEntityManager.findById(jobId);
            if (job == null) continue;
            this.jobServiceConfiguration.getJobManager().unacquire(job);
        }
        return null;
    }
}

