/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages.key;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.yubico.u2f.crypto.BouncyCastleCrypto;
import com.yubico.u2f.crypto.Crypto;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.key.util.ByteInputStream;
import com.yubico.u2f.data.messages.key.util.CertificateParser;
import com.yubico.u2f.data.messages.key.util.U2fB64Encoding;
import com.yubico.u2f.exceptions.U2fBadInputException;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import lombok.Generated;

@Deprecated
public class RawRegisterResponse {
    public static final byte REGISTRATION_RESERVED_BYTE_VALUE = 5;
    public static final byte REGISTRATION_SIGNED_RESERVED_BYTE_VALUE = 0;
    private final transient Crypto crypto;
    final byte[] userPublicKey;
    final byte[] keyHandle;
    final X509Certificate attestationCertificate;
    final byte[] signature;

    public RawRegisterResponse(byte[] userPublicKey, byte[] keyHandle, X509Certificate attestationCertificate, byte[] signature) {
        this(userPublicKey, keyHandle, attestationCertificate, signature, new BouncyCastleCrypto());
    }

    public RawRegisterResponse(byte[] userPublicKey, byte[] keyHandle, X509Certificate attestationCertificate, byte[] signature, Crypto crypto) {
        this.userPublicKey = userPublicKey;
        this.keyHandle = keyHandle;
        this.attestationCertificate = attestationCertificate;
        this.signature = signature;
        this.crypto = crypto;
    }

    public static RawRegisterResponse fromBase64(String rawDataBase64, Crypto crypto) throws U2fBadInputException {
        ByteInputStream bytes = new ByteInputStream(U2fB64Encoding.decode(rawDataBase64));
        try {
            byte reservedByte = bytes.readSigned();
            if (reservedByte != 5) {
                throw new U2fBadInputException("Incorrect value of reserved byte. Expected: 5. Was: " + reservedByte);
            }
            return new RawRegisterResponse(bytes.read(65), bytes.read(bytes.readUnsigned()), CertificateParser.parseDer(bytes), bytes.readAll(), crypto);
        }
        catch (CertificateException e) {
            throw new U2fBadInputException("Malformed attestation certificate", e);
        }
        catch (IOException e) {
            throw new U2fBadInputException("Truncated registration data", e);
        }
    }

    public void checkSignature(String appId, String clientData) throws U2fBadInputException {
        byte[] signedBytes = RawRegisterResponse.packBytesToSign(this.crypto.hash(appId), this.crypto.hash(clientData), this.keyHandle, this.userPublicKey);
        this.crypto.checkSignature(this.attestationCertificate, signedBytes, this.signature);
    }

    public static byte[] packBytesToSign(byte[] appIdHash, byte[] clientDataHash, byte[] keyHandle, byte[] userPublicKey) {
        ByteArrayDataOutput encoded = ByteStreams.newDataOutput();
        encoded.write(0);
        encoded.write(appIdHash);
        encoded.write(clientDataHash);
        encoded.write(keyHandle);
        encoded.write(userPublicKey);
        return encoded.toByteArray();
    }

    public DeviceRegistration createDevice() throws U2fBadInputException {
        return new DeviceRegistration(U2fB64Encoding.encode(this.keyHandle), U2fB64Encoding.encode(this.userPublicKey), this.attestationCertificate, -1L);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawRegisterResponse)) {
            return false;
        }
        RawRegisterResponse other = (RawRegisterResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.userPublicKey, other.userPublicKey)) {
            return false;
        }
        if (!Arrays.equals(this.keyHandle, other.keyHandle)) {
            return false;
        }
        X509Certificate this$attestationCertificate = this.attestationCertificate;
        X509Certificate other$attestationCertificate = other.attestationCertificate;
        if (this$attestationCertificate == null ? other$attestationCertificate != null : !((Object)this$attestationCertificate).equals(other$attestationCertificate)) {
            return false;
        }
        return Arrays.equals(this.signature, other.signature);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RawRegisterResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.userPublicKey);
        result = result * 59 + Arrays.hashCode(this.keyHandle);
        X509Certificate $attestationCertificate = this.attestationCertificate;
        result = result * 59 + ($attestationCertificate == null ? 43 : ((Object)$attestationCertificate).hashCode());
        result = result * 59 + Arrays.hashCode(this.signature);
        return result;
    }
}

