/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.revocation.checker;

import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.security.auth.x500.X500Principal;
import lombok.Generated;
import org.apereo.cas.adaptors.x509.authentication.CRLFetcher;
import org.apereo.cas.adaptors.x509.authentication.ResourceCRLFetcher;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.AbstractCRLRevocationChecker;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.RevocationPolicy;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class ResourceCRLRevocationChecker
extends AbstractCRLRevocationChecker
implements InitializingBean,
DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceCRLRevocationChecker.class);
    private static final int DEFAULT_REFRESH_INTERVAL = 3600;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final int refreshInterval;
    private final CRLFetcher fetcher;
    private final Map<X500Principal, X509CRL> crlIssuerMap = Collections.synchronizedMap(new HashMap(0));
    private final Collection<Resource> resources;

    public ResourceCRLRevocationChecker(boolean checkAll, RevocationPolicy<Void> unavailableCRLPolicy, RevocationPolicy<X509CRL> expiredCRLPolicy, int refreshInterval, CRLFetcher fetcher, Collection<Resource> resources) {
        super(checkAll, unavailableCRLPolicy, expiredCRLPolicy);
        this.refreshInterval = refreshInterval;
        this.fetcher = fetcher;
        this.resources = resources;
    }

    public ResourceCRLRevocationChecker(Resource crl, RevocationPolicy<Void> unavailableCRLPolicy, RevocationPolicy<X509CRL> expiredCRLPolicy) {
        this(false, unavailableCRLPolicy, expiredCRLPolicy, 3600, new ResourceCRLFetcher(), CollectionUtils.wrap((Object)crl));
    }

    public ResourceCRLRevocationChecker(Resource[] crl, RevocationPolicy<X509CRL> expiredCRLPolicy) {
        this(false, null, expiredCRLPolicy, 3600, new ResourceCRLFetcher(), CollectionUtils.wrapList((Object[])crl));
    }

    public ResourceCRLRevocationChecker(Resource crl) {
        this(CollectionUtils.wrap((Object)crl));
    }

    public ResourceCRLRevocationChecker(Collection<Resource> crls) {
        this(new ResourceCRLFetcher(), crls, 3600);
    }

    public ResourceCRLRevocationChecker(CRLFetcher fetcher, Collection<Resource> crls, int refreshInterval) {
        this(false, null, null, refreshInterval, fetcher, crls);
    }

    public void afterPropertiesSet() {
        this.init();
    }

    public void init() {
        if (!this.validateConfiguration()) {
            return;
        }
        Collection results = (Collection)FunctionUtils.doUnchecked(() -> this.fetcher.fetch(this.getResources()));
        this.addCrls(results);
        Runnable scheduledFetcher = () -> {
            try {
                Collection<X509CRL> fetchedResults = this.getFetcher().fetch(this.getResources());
                this.addCrls(fetchedResults);
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        };
        this.scheduler.scheduleAtFixedRate(scheduledFetcher, this.refreshInterval, this.refreshInterval, TimeUnit.SECONDS);
    }

    public void destroy() {
        this.shutdown();
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }

    @Override
    protected boolean addCRL(Object issuer, X509CRL crl) {
        LOGGER.debug("Adding CRL for issuer [{}]", issuer);
        this.crlIssuerMap.put((X500Principal)issuer, crl);
        return this.crlIssuerMap.containsKey(issuer);
    }

    @Override
    protected Collection<X509CRL> getCRLs(X509Certificate cert) {
        X500Principal principal = cert.getIssuerX500Principal();
        if (this.crlIssuerMap.containsKey(principal)) {
            return CollectionUtils.wrap((Object)this.crlIssuerMap.get(principal));
        }
        LOGGER.warn("Could not locate CRL for issuer principal [{}]", (Object)principal);
        return new ArrayList<X509CRL>(0);
    }

    private boolean validateConfiguration() {
        if (this.resources == null || this.resources.isEmpty()) {
            LOGGER.debug("[{}] is not configured with resources. Skipping configuration...", (Object)this.getClass().getSimpleName());
            return false;
        }
        return true;
    }

    private void addCrls(Collection<X509CRL> results) {
        results.forEach(entry -> this.addCRL(entry.getIssuerX500Principal(), (X509CRL)entry));
    }

    @Generated
    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Generated
    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    @Generated
    public CRLFetcher getFetcher() {
        return this.fetcher;
    }

    @Generated
    public Map<X500Principal, X509CRL> getCrlIssuerMap() {
        return this.crlIssuerMap;
    }

    @Generated
    public Collection<Resource> getResources() {
        return this.resources;
    }
}

