/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.DelegationTO;
import org.apache.syncope.common.lib.to.RoleTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Delegation;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.data.DelegationDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegationDataBinderImpl
implements DelegationDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(DelegationDataBinder.class);
    protected final UserDAO userDAO;
    protected final RoleDAO roleDAO;
    protected final EntityFactory entityFactory;

    public DelegationDataBinderImpl(UserDAO userDAO, RoleDAO roleDAO, EntityFactory entityFactory) {
        this.userDAO = userDAO;
        this.roleDAO = roleDAO;
        this.entityFactory = entityFactory;
    }

    public Delegation create(DelegationTO delegationTO) {
        Delegation delegation = (Delegation)this.entityFactory.newEntity(Delegation.class);
        User delegating = Optional.ofNullable((User)this.userDAO.find(delegationTO.getDelegating())).orElseThrow(() -> new NotFoundException("Delegating User " + delegationTO.getDelegating()));
        delegation.setDelegating(delegating);
        User delegated = Optional.ofNullable((User)this.userDAO.find(delegationTO.getDelegated())).orElseThrow(() -> new NotFoundException("Delegated User " + delegationTO.getDelegated()));
        delegation.setDelegated(delegated);
        return this.update(delegation, delegationTO);
    }

    public Delegation update(Delegation delegation, DelegationTO delegationTO) {
        delegation.setStart(delegationTO.getStart());
        delegation.setEnd(delegationTO.getEnd());
        delegationTO.getRoles().forEach(roleTO -> {
            if (roleTO == null) {
                LOG.error("Null {}", (Object)RoleTO.class.getSimpleName());
            } else {
                Role role = this.roleDAO.find(roleTO);
                if (role == null) {
                    SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRole);
                    sce.getElements().add("Role " + roleTO + " not found");
                    throw sce;
                }
                delegation.add(role);
            }
        });
        Iterator itor = delegation.getRoles().iterator();
        while (itor.hasNext()) {
            Role role = (Role)itor.next();
            if (delegationTO.getRoles().stream().anyMatch(roleKey -> roleKey.equals(role.getKey()))) continue;
            itor.remove();
        }
        return delegation;
    }

    public DelegationTO getDelegationTO(Delegation delegation) {
        DelegationTO delegationTO = new DelegationTO();
        delegationTO.setKey(delegation.getKey());
        delegationTO.setDelegating(delegation.getDelegating().getKey());
        delegationTO.setDelegated(delegation.getDelegated().getKey());
        delegationTO.setStart(delegation.getStart());
        delegationTO.setEnd(delegation.getEnd());
        delegationTO.getRoles().addAll(delegation.getRoles().stream().map(Entity::getKey).collect(Collectors.toSet()));
        return delegationTO;
    }
}

