/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pattern;

import java.util.Map;
import org.apache.lucene.analysis.pattern.SimplePatternTokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;

public class SimplePatternTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "simplePattern";
    public static final String PATTERN = "pattern";
    private final Automaton dfa;
    private final int determinizeWorkLimit;

    public SimplePatternTokenizerFactory(Map<String, String> args) {
        super(args);
        this.determinizeWorkLimit = this.getInt(args, "determinizeWorkLimit", 10000);
        this.dfa = Operations.determinize(new RegExp(this.require(args, PATTERN)).toAutomaton(), this.determinizeWorkLimit);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public SimplePatternTokenizer create(AttributeFactory factory) {
        return new SimplePatternTokenizer(factory, this.dfa);
    }
}

