/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.lang.ThrowableUtils;
import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPool;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPoolManager;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.impl.PoolBackedDataSourceBase;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public abstract class AbstractPoolBackedDataSource
extends PoolBackedDataSourceBase
implements PooledDataSource {
    static final MLogger logger = MLog.getLogger(AbstractPoolBackedDataSource.class);
    static final String NO_CPDS_ERR_MSG = "Attempted to use an uninitialized PoolBackedDataSource. Please call setConnectionPoolDataSource( ... ) to initialize.";
    transient C3P0PooledConnectionPoolManager poolManager;
    transient boolean is_closed = false;
    private static final long serialVersionUID = 1L;
    private static final short VERSION = 1;

    protected AbstractPoolBackedDataSource(boolean bl) {
        super(bl);
        this.setUpPropertyEvents();
    }

    private void setUpPropertyEvents() {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AbstractPoolBackedDataSource.this.resetPoolManager(false);
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
    }

    protected void initializeNamedConfig(String string, boolean bl) {
        block4: {
            try {
                if (string != null) {
                    C3P0Config.bindNamedConfigToBean(this, string, bl);
                    if (this.getDataSourceName().equals(this.getIdentityToken())) {
                        this.setDataSourceName(string);
                    }
                }
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block4;
                logger.log(MLevel.WARNING, "Error binding PoolBackedDataSource to named-config '" + string + "'. Some default-config values may be used.", exception);
            }
        }
    }

    @Override
    public String getDataSourceName() {
        String string = super.getDataSourceName();
        if (string == null) {
            string = this.getIdentityToken();
        }
        return string;
    }

    @Override
    public Connection getConnection() throws SQLException {
        PooledConnection pooledConnection = this.getPoolManager().getPool().checkoutPooledConnection();
        return pooledConnection.getConnection();
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        PooledConnection pooledConnection = this.getPoolManager().getPool(string, string2).checkoutPooledConnection();
        return pooledConnection.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.assertCpds().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.assertCpds().setLogWriter(printWriter);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.assertCpds().getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.assertCpds().setLoginTimeout(n);
    }

    @Override
    public int getNumConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumConnections();
    }

    @Override
    public int getNumIdleConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumIdleConnections();
    }

    @Override
    public int getNumBusyConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumBusyConnections();
    }

    @Override
    public int getNumUnclosedOrphanedConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumUnclosedOrphanedConnections();
    }

    @Override
    public int getNumConnectionsDefaultUser() throws SQLException {
        return this.getNumConnections();
    }

    @Override
    public int getNumIdleConnectionsDefaultUser() throws SQLException {
        return this.getNumIdleConnections();
    }

    @Override
    public int getNumBusyConnectionsDefaultUser() throws SQLException {
        return this.getNumBusyConnections();
    }

    @Override
    public int getNumUnclosedOrphanedConnectionsDefaultUser() throws SQLException {
        return this.getNumUnclosedOrphanedConnections();
    }

    @Override
    public int getStatementCacheNumStatementsDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getStatementCacheNumStatements();
    }

    @Override
    public int getStatementCacheNumCheckedOutDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getStatementCacheNumCheckedOut();
    }

    @Override
    public int getStatementCacheNumConnectionsWithCachedStatementsDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getStatementCacheNumConnectionsWithCachedStatements();
    }

    @Override
    public float getEffectivePropertyCycleDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getEffectivePropertyCycle();
    }

    @Override
    public long getStartTimeMillisDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getStartTime();
    }

    @Override
    public long getUpTimeMillisDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getUpTime();
    }

    @Override
    public long getNumFailedCheckinsDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getNumFailedCheckins();
    }

    @Override
    public long getNumFailedCheckoutsDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getNumFailedCheckouts();
    }

    @Override
    public long getNumFailedIdleTestsDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getNumFailedIdleTests();
    }

    @Override
    public int getNumThreadsAwaitingCheckoutDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getNumThreadsAwaitingCheckout();
    }

    @Override
    public int getThreadPoolSize() throws SQLException {
        return this.getPoolManager().getThreadPoolSize();
    }

    @Override
    public int getThreadPoolNumActiveThreads() throws SQLException {
        return this.getPoolManager().getThreadPoolNumActiveThreads();
    }

    @Override
    public int getThreadPoolNumIdleThreads() throws SQLException {
        return this.getPoolManager().getThreadPoolNumIdleThreads();
    }

    @Override
    public int getThreadPoolNumTasksPending() throws SQLException {
        return this.getPoolManager().getThreadPoolNumTasksPending();
    }

    @Override
    public String sampleThreadPoolStackTraces() throws SQLException {
        return this.getPoolManager().getThreadPoolStackTraces();
    }

    @Override
    public String sampleThreadPoolStatus() throws SQLException {
        return this.getPoolManager().getThreadPoolStatus();
    }

    @Override
    public String sampleStatementCacheStatusDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().dumpStatementCacheStatus();
    }

    @Override
    public String sampleStatementCacheStatus(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).dumpStatementCacheStatus();
    }

    @Override
    public Throwable getLastAcquisitionFailureDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getLastAcquisitionFailure();
    }

    @Override
    public Throwable getLastCheckinFailureDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getLastCheckinFailure();
    }

    @Override
    public Throwable getLastCheckoutFailureDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getLastCheckoutFailure();
    }

    @Override
    public Throwable getLastIdleTestFailureDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getLastIdleTestFailure();
    }

    @Override
    public Throwable getLastConnectionTestFailureDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getLastConnectionTestFailure();
    }

    @Override
    public Throwable getLastAcquisitionFailure(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getLastAcquisitionFailure();
    }

    @Override
    public Throwable getLastCheckinFailure(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getLastCheckinFailure();
    }

    @Override
    public Throwable getLastCheckoutFailure(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getLastCheckoutFailure();
    }

    @Override
    public Throwable getLastIdleTestFailure(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getLastIdleTestFailure();
    }

    @Override
    public Throwable getLastConnectionTestFailure(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getLastConnectionTestFailure();
    }

    @Override
    public int getNumThreadsAwaitingCheckout(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getNumThreadsAwaitingCheckout();
    }

    @Override
    public String sampleLastAcquisitionFailureStackTraceDefaultUser() throws SQLException {
        Throwable throwable = this.getLastAcquisitionFailureDefaultUser();
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    @Override
    public String sampleLastCheckinFailureStackTraceDefaultUser() throws SQLException {
        Throwable throwable = this.getLastCheckinFailureDefaultUser();
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    @Override
    public String sampleLastCheckoutFailureStackTraceDefaultUser() throws SQLException {
        Throwable throwable = this.getLastCheckoutFailureDefaultUser();
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    @Override
    public String sampleLastIdleTestFailureStackTraceDefaultUser() throws SQLException {
        Throwable throwable = this.getLastIdleTestFailureDefaultUser();
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    @Override
    public String sampleLastConnectionTestFailureStackTraceDefaultUser() throws SQLException {
        Throwable throwable = this.getLastConnectionTestFailureDefaultUser();
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    @Override
    public String sampleLastAcquisitionFailureStackTrace(String string, String string2) throws SQLException {
        Throwable throwable = this.getLastAcquisitionFailure(string, string2);
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    @Override
    public String sampleLastCheckinFailureStackTrace(String string, String string2) throws SQLException {
        Throwable throwable = this.getLastCheckinFailure(string, string2);
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    @Override
    public String sampleLastCheckoutFailureStackTrace(String string, String string2) throws SQLException {
        Throwable throwable = this.getLastCheckoutFailure(string, string2);
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    @Override
    public String sampleLastIdleTestFailureStackTrace(String string, String string2) throws SQLException {
        Throwable throwable = this.getLastIdleTestFailure(string, string2);
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    @Override
    public String sampleLastConnectionTestFailureStackTrace(String string, String string2) throws SQLException {
        Throwable throwable = this.getLastConnectionTestFailure(string, string2);
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    @Override
    public void softResetDefaultUser() throws SQLException {
        this.getPoolManager().getPool().reset();
    }

    @Override
    public int getNumConnections(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getNumConnections();
    }

    @Override
    public int getNumIdleConnections(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getNumIdleConnections();
    }

    @Override
    public int getNumBusyConnections(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getNumBusyConnections();
    }

    @Override
    public int getNumUnclosedOrphanedConnections(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getNumUnclosedOrphanedConnections();
    }

    @Override
    public int getStatementCacheNumStatements(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getStatementCacheNumStatements();
    }

    @Override
    public int getStatementCacheNumCheckedOut(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getStatementCacheNumCheckedOut();
    }

    @Override
    public int getStatementCacheNumConnectionsWithCachedStatements(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getStatementCacheNumConnectionsWithCachedStatements();
    }

    @Override
    public float getEffectivePropertyCycle(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getEffectivePropertyCycle();
    }

    public long getStartTimeMillis(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getStartTime();
    }

    public long getUpTimeMillis(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getUpTime();
    }

    public long getNumFailedCheckins(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getNumFailedCheckins();
    }

    public long getNumFailedCheckouts(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getNumFailedCheckouts();
    }

    public long getNumFailedIdleTests(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getNumFailedIdleTests();
    }

    @Override
    public void softReset(String string, String string2) throws SQLException {
        this.assertAuthPool(string, string2).reset();
    }

    @Override
    public int getNumBusyConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumBusyConnectionsAllAuths();
    }

    @Override
    public int getNumIdleConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumIdleConnectionsAllAuths();
    }

    @Override
    public int getNumConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumConnectionsAllAuths();
    }

    @Override
    public int getNumUnclosedOrphanedConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumUnclosedOrphanedConnectionsAllAuths();
    }

    @Override
    public int getStatementCacheNumStatementsAllUsers() throws SQLException {
        return this.getPoolManager().getStatementCacheNumStatementsAllUsers();
    }

    @Override
    public int getStatementCacheNumCheckedOutStatementsAllUsers() throws SQLException {
        return this.getPoolManager().getStatementCacheNumCheckedOutStatementsAllUsers();
    }

    @Override
    public int getStatementCacheNumConnectionsWithCachedStatementsAllUsers() throws SQLException {
        return this.getPoolManager().getStatementCacheNumConnectionsWithCachedStatementsAllUsers();
    }

    @Override
    public int getStatementDestroyerNumConnectionsInUseAllUsers() throws SQLException {
        return this.getPoolManager().getStatementDestroyerNumConnectionsInUseAllUsers();
    }

    @Override
    public int getStatementDestroyerNumConnectionsWithDeferredDestroyStatementsAllUsers() throws SQLException {
        return this.getPoolManager().getStatementDestroyerNumConnectionsWithDeferredDestroyStatementsAllUsers();
    }

    @Override
    public int getStatementDestroyerNumDeferredDestroyStatementsAllUsers() throws SQLException {
        return this.getPoolManager().getStatementDestroyerNumDeferredDestroyStatementsAllUsers();
    }

    @Override
    public int getStatementDestroyerNumConnectionsInUseDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getStatementDestroyerNumConnectionsInUse();
    }

    @Override
    public int getStatementDestroyerNumConnectionsWithDeferredDestroyStatementsDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getStatementDestroyerNumConnectionsWithDeferredDestroyStatements();
    }

    @Override
    public int getStatementDestroyerNumDeferredDestroyStatementsDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getStatementDestroyerNumDeferredDestroyStatements();
    }

    @Override
    public int getStatementDestroyerNumThreads() throws SQLException {
        return this.getPoolManager().getStatementDestroyerNumThreads();
    }

    @Override
    public int getStatementDestroyerNumActiveThreads() throws SQLException {
        return this.getPoolManager().getStatementDestroyerNumActiveThreads();
    }

    @Override
    public int getStatementDestroyerNumIdleThreads() throws SQLException {
        return this.getPoolManager().getStatementDestroyerNumIdleThreads();
    }

    @Override
    public int getStatementDestroyerNumTasksPending() throws SQLException {
        return this.getPoolManager().getStatementDestroyerNumTasksPending();
    }

    @Override
    public int getStatementDestroyerNumConnectionsInUse(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getStatementDestroyerNumConnectionsInUse();
    }

    @Override
    public int getStatementDestroyerNumConnectionsWithDeferredDestroyStatements(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getStatementDestroyerNumConnectionsWithDeferredDestroyStatements();
    }

    @Override
    public int getStatementDestroyerNumDeferredDestroyStatements(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getStatementDestroyerNumDeferredDestroyStatements();
    }

    @Override
    public String sampleStatementDestroyerStackTraces() throws SQLException {
        return this.getPoolManager().getStatementDestroyerStackTraces();
    }

    @Override
    public String sampleStatementDestroyerStatus() throws SQLException {
        return this.getPoolManager().getStatementDestroyerStatus();
    }

    @Override
    public void softResetAllUsers() throws SQLException {
        this.getPoolManager().softResetAllAuths();
    }

    @Override
    public int getNumUserPools() throws SQLException {
        return this.getPoolManager().getNumManagedAuths();
    }

    @Override
    public Collection getAllUsers() throws SQLException {
        LinkedList<String> linkedList = new LinkedList<String>();
        Set set = this.getPoolManager().getManagedAuths();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            linkedList.add(((DbAuth)iterator.next()).getUser());
        }
        return Collections.unmodifiableList(linkedList);
    }

    @Override
    public synchronized void hardReset() {
        this.resetPoolManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AbstractPoolBackedDataSource abstractPoolBackedDataSource = this;
        synchronized (abstractPoolBackedDataSource) {
            this.resetPoolManager();
            this.is_closed = true;
        }
        C3P0Registry.markClosed(this);
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.log(MLevel.FINEST, this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this)) + " has been closed. ", new Exception("DEBUG STACK TRACE for PoolBackedDataSource.close()."));
        }
    }

    @Override
    public void close(boolean bl) {
        this.close();
    }

    public synchronized void resetPoolManager() {
        this.resetPoolManager(true);
    }

    public synchronized void resetPoolManager(boolean bl) {
        if (this.poolManager != null) {
            this.poolManager.close(bl);
            this.poolManager = null;
        }
    }

    private synchronized ConnectionPoolDataSource assertCpds() throws SQLException {
        if (this.is_closed) {
            throw new SQLException(this + " has been closed() -- you can no longer use it.");
        }
        ConnectionPoolDataSource connectionPoolDataSource = this.getConnectionPoolDataSource();
        if (connectionPoolDataSource == null) {
            throw new SQLException(NO_CPDS_ERR_MSG);
        }
        return connectionPoolDataSource;
    }

    private synchronized C3P0PooledConnectionPoolManager getPoolManager() throws SQLException {
        if (this.poolManager == null) {
            ConnectionPoolDataSource connectionPoolDataSource = this.assertCpds();
            this.poolManager = new C3P0PooledConnectionPoolManager(connectionPoolDataSource, null, null, this.getNumHelperThreads(), this.getIdentityToken(), this.getDataSourceName());
            if (logger.isLoggable(MLevel.INFO)) {
                logger.info("Initializing c3p0 pool... " + this.toString(true));
            }
        }
        return this.poolManager;
    }

    private C3P0PooledConnectionPool assertAuthPool(String string, String string2) throws SQLException {
        C3P0PooledConnectionPool c3P0PooledConnectionPool = this.getPoolManager().getPool(string, string2, false);
        if (c3P0PooledConnectionPool == null) {
            throw new SQLException("No pool has been yet been established for Connections authenticated by user '" + string + "' with the password provided. [Use getConnection( username, password ) to initialize such a pool.]");
        }
        return c3P0PooledConnectionPool;
    }

    public abstract String toString(boolean var1);

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeShort(1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        short s = objectInputStream.readShort();
        switch (s) {
            case 1: {
                this.setUpPropertyEvents();
                break;
            }
            default: {
                throw new IOException("Unsupported Serialized Version: " + s);
            }
        }
    }

    protected final boolean isWrapperForThis(Class<?> clazz) {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return this.isWrapperForThis(clazz);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperForThis(clazz)) {
            return (T)this;
        }
        throw new SQLException(this + " is not a wrapper for or implementation of " + clazz.getName());
    }
}

