/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import org.apache.sis.internal.metadata.Resources;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.UnmodifiableMetadataException;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.quality.Element;

final class SpecialCases
extends PropertyAccessor {
    private final int westBoundLongitude;
    private final int eastBoundLongitude;
    private final int southBoundLatitude;
    private final int northBoundLatitude;

    SpecialCases(Class<?> clazz, Class<?> clazz2, Class<?> clazz3) {
        super(clazz, clazz2, clazz3);
        assert (SpecialCases.isSpecialCase(clazz)) : clazz;
        this.westBoundLongitude = this.indexOf("westBoundLongitude", true);
        this.eastBoundLongitude = this.indexOf("eastBoundLongitude", true);
        this.southBoundLatitude = this.indexOf("southBoundLatitude", true);
        this.northBoundLatitude = this.indexOf("northBoundLatitude", true);
    }

    static boolean isSpecialCase(Class<?> clazz) {
        return clazz == GeographicBoundingBox.class;
    }

    static boolean exclude(Class<?> clazz, String string) {
        return string.equals("getMeasure") && Element.class.isAssignableFrom(clazz);
    }

    @Override
    Class<?> type(int n, TypeValuePolicy typeValuePolicy) {
        Class<Object> clazz = super.type(n, typeValuePolicy);
        switch (typeValuePolicy) {
            case PROPERTY_TYPE: 
            case ELEMENT_TYPE: {
                if (n == this.westBoundLongitude || n == this.eastBoundLongitude) {
                    clazz = Longitude.class;
                    break;
                }
                if (n != this.southBoundLatitude && n != this.northBoundLatitude) break;
                clazz = Latitude.class;
            }
        }
        return clazz;
    }

    @Override
    CharSequence remarks(int n, Object object) {
        Object object2;
        Object object3;
        if (n == this.eastBoundLongitude && (object3 = super.get(n, object)) != null && (object2 = super.get(this.westBoundLongitude, object)) != null && Longitude.isWraparound((Double)object2, (Double)object3)) {
            return Resources.formatInternational((short)3);
        }
        return super.remarks(n, object);
    }

    @Override
    Object get(int n, Object object) throws BackingStoreException {
        Object object2 = super.get(n, object);
        if (object2 != null) {
            if (n == this.westBoundLongitude || n == this.eastBoundLongitude) {
                double d = (Double)object2;
                object2 = Double.isNaN(d) ? null : new Longitude(d);
            } else if (n == this.southBoundLatitude || n == this.northBoundLatitude) {
                double d = (Double)object2;
                object2 = Double.isNaN(d) ? null : new Latitude(d);
            }
        }
        return object2;
    }

    @Override
    Object set(int n, Object object, Object object2, int n2) throws UnmodifiableMetadataException, ClassCastException, BackingStoreException {
        if (n == this.westBoundLongitude || n == this.eastBoundLongitude) {
            if (object2 instanceof Longitude) {
                object2 = ((Longitude)object2).degrees();
            }
            if ((object2 = super.set(n, object, object2, n2)) != null) {
                object2 = new Longitude((Double)object2);
            }
            return object2;
        }
        if (n == this.southBoundLatitude || n == this.northBoundLatitude) {
            if (object2 instanceof Latitude) {
                object2 = ((Latitude)object2).degrees();
            }
            if ((object2 = super.set(n, object, object2, n2)) != null) {
                object2 = new Latitude((Double)object2);
            }
            return object2;
        }
        return super.set(n, object, object2, n2);
    }

    static boolean isLocaleAndCharset(PropertyAccessor propertyAccessor, int n) {
        return propertyAccessor.isMap(n) && propertyAccessor.type.getName().startsWith("org.opengis.metadata.") && "localesAndCharsets".equals(propertyAccessor.name(n, KeyNamePolicy.JAVABEANS_PROPERTY));
    }

    static String rename(String string) {
        if ("defaultLocale+otherLocale".equals(string)) {
            return "locale";
        }
        return string;
    }
}

