/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.xml.bind.JAXBException;
import org.apache.sis.internal.referencing.MergedProperties;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.io.wkt.Parser;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.DefaultCompoundCRS;
import org.apache.sis.referencing.crs.DefaultDerivedCRS;
import org.apache.sis.referencing.crs.DefaultEngineeringCRS;
import org.apache.sis.referencing.crs.DefaultGeocentricCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultImageCRS;
import org.apache.sis.referencing.crs.DefaultParametricCRS;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.DefaultAffineCS;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.cs.DefaultCylindricalCS;
import org.apache.sis.referencing.cs.DefaultEllipsoidalCS;
import org.apache.sis.referencing.cs.DefaultLinearCS;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.cs.DefaultPolarCS;
import org.apache.sis.referencing.cs.DefaultSphericalCS;
import org.apache.sis.referencing.cs.DefaultTimeCS;
import org.apache.sis.referencing.cs.DefaultUserDefinedCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.datum.DefaultEngineeringDatum;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultImageDatum;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.referencing.datum.DefaultTemporalDatum;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.xml.XML;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.referencing.ObjectFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.UserDefinedCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

public class GeodeticObjectFactory
extends AbstractFactory
implements CRSFactory,
CSFactory,
DatumFactory,
Parser {
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.referencing.factory");
    private static volatile Constructor<? extends Parser> parserConstructor;
    private final Map<String, ?> defaultProperties;
    private volatile MathTransformFactory mtFactory;
    private final WeakHashSet<AbstractIdentifiedObject> pool;
    private final AtomicReference<Parser> parser;

    public GeodeticObjectFactory() {
        this(null);
    }

    public GeodeticObjectFactory(Map<String, ?> map) {
        map = map == null || map.isEmpty() ? Collections.emptyMap() : CollectionsExt.compact(new HashMap(map));
        this.defaultProperties = map;
        this.pool = new WeakHashSet<AbstractIdentifiedObject>(AbstractIdentifiedObject.class);
        this.parser = new AtomicReference();
    }

    protected Map<String, ?> complete(Map<String, ?> map) {
        ArgumentChecks.ensureNonNull("properties", map);
        return new MergedProperties(map, this.defaultProperties){

            @Override
            protected Object invisibleEntry(Object object) {
                if ("mtFactory".equals(object)) {
                    return GeodeticObjectFactory.this.getMathTransformFactory();
                }
                return super.invisibleEntry(object);
            }
        };
    }

    final MathTransformFactory getMathTransformFactory() {
        MathTransformFactory mathTransformFactory = this.mtFactory;
        if (mathTransformFactory == null) {
            this.mtFactory = mathTransformFactory = DefaultFactories.forBuildin(MathTransformFactory.class);
        }
        return mathTransformFactory;
    }

    private <T extends AbstractIdentifiedObject> T unique(String string, T t) {
        T t2 = this.pool.unique(t);
        if (t2 == t) {
            Level level;
            Level level2 = level = Semaphores.query(32) ? Level.FINER : Level.FINE;
            if (LOGGER.isLoggable(level)) {
                String string2 = IdentifiedObjects.toString(IdentifiedObjects.getIdentifier(t2, null));
                LogRecord logRecord = Messages.getResources(null).getLogRecord(level, string2 != null ? (short)9 : 10, t2.getInterface(), t2.getName().getCode(), string2);
                logRecord.setSourceClassName(GeodeticObjectFactory.class.getCanonicalName());
                logRecord.setSourceMethodName(string);
                logRecord.setLoggerName(LOGGER.getName());
                LOGGER.log(logRecord);
            }
        }
        return t2;
    }

    @Override
    public GeocentricCRS createGeocentricCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, CartesianCS cartesianCS) throws FactoryException {
        DefaultGeocentricCRS defaultGeocentricCRS;
        try {
            defaultGeocentricCRS = new DefaultGeocentricCRS(this.complete(map), geodeticDatum, cartesianCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createGeocentricCRS", defaultGeocentricCRS);
    }

    @Override
    public CartesianCS createCartesianCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        DefaultCartesianCS defaultCartesianCS;
        try {
            defaultCartesianCS = new DefaultCartesianCS(this.complete(map), coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createCartesianCS", defaultCartesianCS);
    }

    @Override
    public GeocentricCRS createGeocentricCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, SphericalCS sphericalCS) throws FactoryException {
        DefaultGeocentricCRS defaultGeocentricCRS;
        try {
            defaultGeocentricCRS = new DefaultGeocentricCRS(this.complete(map), geodeticDatum, sphericalCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createGeocentricCRS", defaultGeocentricCRS);
    }

    @Override
    public SphericalCS createSphericalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        DefaultSphericalCS defaultSphericalCS;
        try {
            defaultSphericalCS = new DefaultSphericalCS(this.complete(map), coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createSphericalCS", defaultSphericalCS);
    }

    @Override
    public GeographicCRS createGeographicCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, EllipsoidalCS ellipsoidalCS) throws FactoryException {
        DefaultGeographicCRS defaultGeographicCRS;
        try {
            defaultGeographicCRS = new DefaultGeographicCRS(this.complete(map), geodeticDatum, ellipsoidalCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createGeographicCRS", defaultGeographicCRS);
    }

    @Override
    public GeodeticDatum createGeodeticDatum(Map<String, ?> map, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) throws FactoryException {
        DefaultGeodeticDatum defaultGeodeticDatum;
        try {
            defaultGeodeticDatum = new DefaultGeodeticDatum(this.complete(map), ellipsoid, primeMeridian);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createGeodeticDatum", defaultGeodeticDatum);
    }

    @Override
    public PrimeMeridian createPrimeMeridian(Map<String, ?> map, double d, Unit<Angle> unit) throws FactoryException {
        DefaultPrimeMeridian defaultPrimeMeridian;
        try {
            defaultPrimeMeridian = new DefaultPrimeMeridian(this.complete(map), d, unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createPrimeMeridian", defaultPrimeMeridian);
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) throws FactoryException {
        DefaultEllipsoidalCS defaultEllipsoidalCS;
        try {
            defaultEllipsoidalCS = new DefaultEllipsoidalCS(this.complete(map), coordinateSystemAxis, coordinateSystemAxis2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createEllipsoidalCS", defaultEllipsoidalCS);
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        DefaultEllipsoidalCS defaultEllipsoidalCS;
        try {
            defaultEllipsoidalCS = new DefaultEllipsoidalCS(this.complete(map), coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createEllipsoidalCS", defaultEllipsoidalCS);
    }

    @Override
    public Ellipsoid createEllipsoid(Map<String, ?> map, double d, double d2, Unit<Length> unit) throws FactoryException {
        DefaultEllipsoid defaultEllipsoid;
        try {
            defaultEllipsoid = DefaultEllipsoid.createEllipsoid(this.complete(map), d, d2, unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createEllipsoid", defaultEllipsoid);
    }

    @Override
    public Ellipsoid createFlattenedSphere(Map<String, ?> map, double d, double d2, Unit<Length> unit) throws FactoryException {
        DefaultEllipsoid defaultEllipsoid;
        try {
            defaultEllipsoid = DefaultEllipsoid.createFlattenedSphere(this.complete(map), d, d2, unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createFlattenedSphere", defaultEllipsoid);
    }

    @Override
    public ProjectedCRS createProjectedCRS(Map<String, ?> map, GeographicCRS geographicCRS, Conversion conversion, CartesianCS cartesianCS) throws FactoryException {
        DefaultProjectedCRS defaultProjectedCRS;
        try {
            defaultProjectedCRS = new DefaultProjectedCRS(this.complete(map), geographicCRS, conversion, cartesianCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Throwable throwable = illegalArgumentException.getCause();
            if (throwable instanceof FactoryException) {
                throw (FactoryException)throwable;
            }
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createProjectedCRS", defaultProjectedCRS);
    }

    @Override
    public CartesianCS createCartesianCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) throws FactoryException {
        DefaultCartesianCS defaultCartesianCS;
        try {
            defaultCartesianCS = new DefaultCartesianCS(this.complete(map), coordinateSystemAxis, coordinateSystemAxis2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createCartesianCS", defaultCartesianCS);
    }

    @Override
    public DerivedCRS createDerivedCRS(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, Conversion conversion, CoordinateSystem coordinateSystem) throws FactoryException {
        DefaultDerivedCRS defaultDerivedCRS;
        ArgumentChecks.ensureCanCast("baseCRS", SingleCRS.class, coordinateReferenceSystem);
        try {
            defaultDerivedCRS = DefaultDerivedCRS.create(this.complete(map), (SingleCRS)coordinateReferenceSystem, conversion, coordinateSystem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Throwable throwable = illegalArgumentException.getCause();
            if (throwable instanceof FactoryException) {
                throw (FactoryException)throwable;
            }
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createDerivedCRS", defaultDerivedCRS);
    }

    @Override
    public VerticalCRS createVerticalCRS(Map<String, ?> map, VerticalDatum verticalDatum, VerticalCS verticalCS) throws FactoryException {
        DefaultVerticalCRS defaultVerticalCRS;
        try {
            defaultVerticalCRS = new DefaultVerticalCRS(this.complete(map), verticalDatum, verticalCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createVerticalCRS", defaultVerticalCRS);
    }

    @Override
    public VerticalDatum createVerticalDatum(Map<String, ?> map, VerticalDatumType verticalDatumType) throws FactoryException {
        DefaultVerticalDatum defaultVerticalDatum;
        try {
            defaultVerticalDatum = new DefaultVerticalDatum(this.complete(map), verticalDatumType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createVerticalDatum", defaultVerticalDatum);
    }

    @Override
    public VerticalCS createVerticalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) throws FactoryException {
        DefaultVerticalCS defaultVerticalCS;
        try {
            defaultVerticalCS = new DefaultVerticalCS(this.complete(map), coordinateSystemAxis);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createVerticalCS", defaultVerticalCS);
    }

    @Override
    public TemporalCRS createTemporalCRS(Map<String, ?> map, TemporalDatum temporalDatum, TimeCS timeCS) throws FactoryException {
        DefaultTemporalCRS defaultTemporalCRS;
        try {
            defaultTemporalCRS = new DefaultTemporalCRS(this.complete(map), temporalDatum, timeCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createTemporalCRS", defaultTemporalCRS);
    }

    @Override
    public TemporalDatum createTemporalDatum(Map<String, ?> map, Date date) throws FactoryException {
        DefaultTemporalDatum defaultTemporalDatum;
        try {
            defaultTemporalDatum = new DefaultTemporalDatum(this.complete(map), date);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createTemporalDatum", defaultTemporalDatum);
    }

    @Override
    public TimeCS createTimeCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) throws FactoryException {
        DefaultTimeCS defaultTimeCS;
        try {
            defaultTimeCS = new DefaultTimeCS(this.complete(map), coordinateSystemAxis);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createTimeCS", defaultTimeCS);
    }

    public DefaultParametricCRS createParametricCRS(Map<String, ?> map, DefaultParametricDatum defaultParametricDatum, DefaultParametricCS defaultParametricCS) throws FactoryException {
        DefaultParametricCRS defaultParametricCRS;
        try {
            defaultParametricCRS = new DefaultParametricCRS(this.complete(map), defaultParametricDatum, defaultParametricCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createParametricCRS", defaultParametricCRS);
    }

    public DefaultParametricDatum createParametricDatum(Map<String, ?> map) throws FactoryException {
        DefaultParametricDatum defaultParametricDatum;
        try {
            defaultParametricDatum = new DefaultParametricDatum(this.complete(map));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createParametricDatum", defaultParametricDatum);
    }

    public DefaultParametricCS createParametricCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) throws FactoryException {
        DefaultParametricCS defaultParametricCS;
        try {
            defaultParametricCS = new DefaultParametricCS(this.complete(map), coordinateSystemAxis);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createParametricCS", defaultParametricCS);
    }

    @Override
    public CompoundCRS createCompoundCRS(Map<String, ?> map, CoordinateReferenceSystem ... coordinateReferenceSystemArray) throws FactoryException {
        DefaultCompoundCRS defaultCompoundCRS;
        try {
            defaultCompoundCRS = new DefaultCompoundCRS(this.complete(map), coordinateReferenceSystemArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createCompoundCRS", defaultCompoundCRS);
    }

    @Override
    public ImageCRS createImageCRS(Map<String, ?> map, ImageDatum imageDatum, AffineCS affineCS) throws FactoryException {
        DefaultImageCRS defaultImageCRS;
        try {
            defaultImageCRS = new DefaultImageCRS(this.complete(map), imageDatum, affineCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createImageCRS", defaultImageCRS);
    }

    @Override
    public ImageDatum createImageDatum(Map<String, ?> map, PixelInCell pixelInCell) throws FactoryException {
        DefaultImageDatum defaultImageDatum;
        try {
            defaultImageDatum = new DefaultImageDatum(this.complete(map), pixelInCell);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createImageDatum", defaultImageDatum);
    }

    @Override
    public AffineCS createAffineCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) throws FactoryException {
        DefaultAffineCS defaultAffineCS;
        try {
            defaultAffineCS = new DefaultAffineCS(this.complete(map), coordinateSystemAxis, coordinateSystemAxis2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createAffineCS", defaultAffineCS);
    }

    @Override
    public EngineeringCRS createEngineeringCRS(Map<String, ?> map, EngineeringDatum engineeringDatum, CoordinateSystem coordinateSystem) throws FactoryException {
        DefaultEngineeringCRS defaultEngineeringCRS;
        try {
            defaultEngineeringCRS = new DefaultEngineeringCRS(this.complete(map), engineeringDatum, coordinateSystem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createEngineeringCRS", defaultEngineeringCRS);
    }

    @Override
    public EngineeringDatum createEngineeringDatum(Map<String, ?> map) throws FactoryException {
        DefaultEngineeringDatum defaultEngineeringDatum;
        try {
            defaultEngineeringDatum = new DefaultEngineeringDatum(this.complete(map));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createEngineeringDatum", defaultEngineeringDatum);
    }

    @Override
    public AffineCS createAffineCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        DefaultAffineCS defaultAffineCS;
        try {
            defaultAffineCS = new DefaultAffineCS(this.complete(map), coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createAffineCS", defaultAffineCS);
    }

    @Override
    public CylindricalCS createCylindricalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        DefaultCylindricalCS defaultCylindricalCS;
        try {
            defaultCylindricalCS = new DefaultCylindricalCS(this.complete(map), coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createCylindricalCS", defaultCylindricalCS);
    }

    @Override
    public PolarCS createPolarCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) throws FactoryException {
        DefaultPolarCS defaultPolarCS;
        try {
            defaultPolarCS = new DefaultPolarCS(this.complete(map), coordinateSystemAxis, coordinateSystemAxis2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createPolarCS", defaultPolarCS);
    }

    @Override
    public LinearCS createLinearCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) throws FactoryException {
        DefaultLinearCS defaultLinearCS;
        try {
            defaultLinearCS = new DefaultLinearCS(this.complete(map), coordinateSystemAxis);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createLinearCS", defaultLinearCS);
    }

    @Override
    public UserDefinedCS createUserDefinedCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) throws FactoryException {
        DefaultUserDefinedCS defaultUserDefinedCS;
        try {
            defaultUserDefinedCS = new DefaultUserDefinedCS(this.complete(map), coordinateSystemAxis, coordinateSystemAxis2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createUserDefinedCS", defaultUserDefinedCS);
    }

    @Override
    public UserDefinedCS createUserDefinedCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        DefaultUserDefinedCS defaultUserDefinedCS;
        try {
            defaultUserDefinedCS = new DefaultUserDefinedCS(this.complete(map), coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createUserDefinedCS", defaultUserDefinedCS);
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(Map<String, ?> map, String string, AxisDirection axisDirection, Unit<?> unit) throws FactoryException {
        DefaultCoordinateSystemAxis defaultCoordinateSystemAxis;
        try {
            defaultCoordinateSystemAxis = new DefaultCoordinateSystemAxis(this.complete(map), string, axisDirection, unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException);
        }
        return this.unique("createCoordinateSystemAxis", defaultCoordinateSystemAxis);
    }

    @Override
    public CoordinateReferenceSystem createFromXML(String string) throws FactoryException {
        Object object;
        try {
            object = XML.unmarshal(string);
        }
        catch (JAXBException jAXBException) {
            JAXBException jAXBException2;
            String string2 = jAXBException.getLocalizedMessage();
            Throwable throwable = jAXBException.getCause();
            if (throwable instanceof Exception) {
                if ((throwable = Exceptions.unwrap((Exception)throwable)) instanceof JAXBException) {
                    jAXBException2 = (JAXBException)throwable;
                }
                if (string2 == null) {
                    string2 = throwable.getLocalizedMessage();
                }
            }
            throw new FactoryException(string2, jAXBException2);
        }
        if (object instanceof CoordinateReferenceSystem) {
            return (CoordinateReferenceSystem)object;
        }
        throw new FactoryException(Errors.getResources(this.defaultProperties).getString((short)50, CoordinateReferenceSystem.class, object.getClass()));
    }

    @Override
    public CoordinateReferenceSystem createFromWKT(String string) throws FactoryException {
        Constructor<Parser> constructor;
        ArgumentChecks.ensureNonEmpty("text", string);
        Parser parser = this.parser.getAndSet(null);
        if (parser == null) {
            try {
                constructor = parserConstructor;
                if (constructor == null) {
                    constructor = Class.forName("org.apache.sis.io.wkt.GeodeticObjectParser").asSubclass(Parser.class).getConstructor(Map.class, ObjectFactory.class, MathTransformFactory.class);
                    constructor.setAccessible(true);
                    parserConstructor = constructor;
                }
                parser = (Parser)constructor.newInstance(this.defaultProperties, this, this.getMathTransformFactory());
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new FactoryException(reflectiveOperationException);
            }
        }
        try {
            constructor = parser.createFromWKT(string);
        }
        catch (FactoryException factoryException) {
            for (Throwable throwable = factoryException.getCause(); throwable != null; throwable = throwable.getCause()) {
                if (!(throwable instanceof ParameterNotFoundException)) continue;
                throw new InvalidGeodeticParameterException(factoryException.getLocalizedMessage(), throwable);
            }
            throw factoryException;
        }
        this.parser.set(parser);
        if (constructor instanceof CoordinateReferenceSystem) {
            return (CoordinateReferenceSystem)((Object)constructor);
        }
        throw new FactoryException(Errors.getResources(this.defaultProperties).getString((short)50, CoordinateReferenceSystem.class, constructor.getClass()));
    }
}

