/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.app.db;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.eval.app.db.ColInfo;
import org.apache.tika.eval.app.db.Cols;
import org.apache.tika.eval.app.db.TableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCUtil.class);
    private final String connectionString;
    private String driverClass;
    private Connection connection = null;

    public JDBCUtil(String connectionString, String driverClass) {
        this.connectionString = connectionString;
        this.driverClass = driverClass;
        if ((driverClass == null || driverClass.isEmpty()) && System.getProperty("jdbc.drivers") == null) {
            try (InputStream is = JDBCUtil.class.getResourceAsStream("/db.properties");){
                Properties properties = new Properties();
                properties.load(is);
                for (String k : properties.stringPropertyNames()) {
                    Matcher m = Pattern.compile("(?i)jdbc:" + k).matcher(connectionString);
                    if (!m.find()) continue;
                    this.driverClass = properties.getProperty(k);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void batchInsert(PreparedStatement insertStatement, TableInfo table, Map<Cols, String> data) throws SQLException {
        try {
            int i = 1;
            for (ColInfo colInfo : table.getColInfos()) {
                JDBCUtil.updateInsertStatement(i, insertStatement, colInfo, data.get((Object)colInfo.getName()));
                ++i;
            }
            for (Cols c : data.keySet()) {
                if (table.containsColumn(c)) continue;
                throw new IllegalArgumentException("Can't add data to " + c + " because it doesn't exist in the table: " + table.getName());
            }
            insertStatement.addBatch();
        }
        catch (SQLException e) {
            LOG.warn("couldn't insert data for this row: {}", (Object)e.getMessage());
        }
    }

    public static void updateInsertStatement(int dbColOffset, PreparedStatement st, ColInfo colInfo, String value) throws SQLException {
        if (value == null) {
            st.setNull(dbColOffset, colInfo.getType());
            return;
        }
        try {
            switch (colInfo.getType()) {
                case 12: {
                    if (value != null && value.length() > colInfo.getPrecision()) {
                        value = value.substring(0, colInfo.getPrecision());
                        LOG.warn("truncated varchar value in {} : {}", (Object)colInfo.getName(), (Object)value);
                    }
                    value = value.replaceAll("\u0000", " ");
                    st.setString(dbColOffset, value);
                    break;
                }
                case 1: {
                    value = value.replaceAll("\u0000", " ");
                    st.setString(dbColOffset, value);
                    break;
                }
                case 8: {
                    st.setDouble(dbColOffset, Double.parseDouble(value));
                    break;
                }
                case 6: {
                    st.setDouble(dbColOffset, Float.parseFloat(value));
                    break;
                }
                case 4: {
                    st.setInt(dbColOffset, Integer.parseInt(value));
                    break;
                }
                case -5: {
                    st.setLong(dbColOffset, Long.parseLong(value));
                    break;
                }
                case 16: {
                    st.setBoolean(dbColOffset, Boolean.parseBoolean(value));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Don't yet support type: " + colInfo.getType());
                }
            }
        }
        catch (NumberFormatException e) {
            if (!"".equals(value)) {
                LOG.warn("number format exception: {} : {}", (Object)colInfo.getName(), (Object)value);
            }
            st.setNull(dbColOffset, colInfo.getType());
        }
        catch (SQLException e) {
            LOG.warn("sqlexception: {} : {}", (Object)colInfo, (Object)value);
            st.setNull(dbColOffset, colInfo.getType());
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.connection != null) {
            return this.connection;
        }
        String connectionString = this.getConnectionString();
        String jdbcDriver = this.getJDBCDriverClass();
        if (jdbcDriver != null) {
            try {
                Class.forName(this.getJDBCDriverClass());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        this.connection = DriverManager.getConnection(connectionString);
        this.connection.setAutoCommit(false);
        return this.connection;
    }

    public String getJDBCDriverClass() {
        return this.driverClass;
    }

    public boolean dropTableIfExists(Connection conn, String tableName) throws SQLException {
        if (this.containsTable(tableName)) {
            try (Statement st = conn.createStatement();){
                String sql = "drop table " + tableName;
                boolean bl = st.execute(sql);
                return bl;
            }
        }
        return true;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public Set<String> getTables(Connection connection) throws SQLException {
        HashSet<String> tables = new HashSet<String>();
        DatabaseMetaData dbMeta = connection.getMetaData();
        try (ResultSet rs = dbMeta.getTables(null, null, "%", null);){
            while (rs.next()) {
                tables.add(rs.getString(3).toLowerCase(Locale.US));
            }
        }
        return tables;
    }

    public void createTables(List<TableInfo> tableInfos, CREATE_TABLE createTable) throws SQLException, IOException {
        Connection conn = this.getConnection();
        for (TableInfo tableInfo : tableInfos) {
            if (createTable.equals((Object)CREATE_TABLE.DROP_IF_EXISTS)) {
                this.dropTableIfExists(conn, tableInfo.getName());
            } else if (createTable.equals((Object)CREATE_TABLE.SKIP_IF_EXISTS) && this.containsTable(tableInfo.getName())) continue;
            this.createTable(conn, tableInfo);
        }
        conn.commit();
    }

    public boolean containsTable(String tableName) throws SQLException {
        Connection connection = this.getConnection();
        Set<String> tables = this.getTables(connection);
        return tables.contains(this.normalizeTableName(tableName));
    }

    String normalizeTableName(String tableName) {
        tableName = tableName.toLowerCase(Locale.US);
        return tableName;
    }

    private void createTable(Connection conn, TableInfo tableInfo) throws SQLException {
        StringBuilder createSql = new StringBuilder();
        createSql.append("CREATE TABLE ").append(tableInfo.getName());
        createSql.append("(");
        int last = 0;
        for (ColInfo col : tableInfo.getColInfos()) {
            if (++last > 1) {
                createSql.append(", ");
            }
            createSql.append((Object)col.getName());
            createSql.append(" ");
            createSql.append(col.getSqlDef());
            String constraints = col.getConstraints();
            if (constraints == null) continue;
            createSql.append(" ");
            createSql.append(constraints);
        }
        createSql.append(")");
        try (Statement st = conn.createStatement();){
            st.execute(createSql.toString());
        }
        conn.commit();
    }

    public static enum CREATE_TABLE {
        DROP_IF_EXISTS,
        SKIP_IF_EXISTS,
        THROW_EX_IF_EXISTS;

    }
}

