/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Temperature;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Scalar;
import org.apache.sis.util.ArgumentChecks;

class DerivedScalar<Q extends Quantity<Q>>
extends Scalar<Q> {
    private static final long serialVersionUID = 3729159568163676568L;
    private final double derivedValue;
    private final Unit<Q> derivedUnit;
    private final UnitConverter fromSystem;

    DerivedScalar(double value, Unit<Q> unit, Unit<Q> systemUnit, UnitConverter toSystem) {
        super(toSystem.convert(value), systemUnit);
        this.derivedValue = value;
        this.derivedUnit = unit;
        this.fromSystem = toSystem.inverse();
    }

    DerivedScalar(DerivedScalar<Q> origin, double value) {
        super(value, origin.getSystemUnit());
        this.derivedUnit = origin.derivedUnit;
        this.fromSystem = origin.fromSystem;
        this.derivedValue = this.fromSystem.convert(value);
    }

    @Override
    Quantity<Q> create(double newValue, Unit<Q> newUnit) {
        assert (newUnit == this.getSystemUnit()) : newUnit;
        return new DerivedScalar<Q>(this, newValue);
    }

    final Unit<Q> getSystemUnit() {
        return super.getUnit();
    }

    @Override
    public final Unit<Q> getUnit() {
        return this.derivedUnit;
    }

    @Override
    public final double doubleValue() {
        return this.derivedValue;
    }

    @Override
    public final float floatValue() {
        return (float)this.derivedValue;
    }

    @Override
    public final long longValue() {
        return Math.round(this.derivedValue);
    }

    @Override
    public final Quantity<Q> to(Unit<Q> newUnit) {
        if (newUnit == this.derivedUnit) {
            return this;
        }
        ArgumentChecks.ensureNonNull("unit", newUnit);
        return Quantities.create(this.derivedUnit.getConverterTo(newUnit).convert(this.derivedValue), newUnit);
    }

    static final class Fallback<Q extends Quantity<Q>>
    extends DerivedScalar<Q>
    implements InvocationHandler {
        private final Class<Q> type;

        private Fallback(double value, Unit<Q> unit, Unit<Q> systemUnit, UnitConverter toSystem, Class<Q> type) {
            super(value, unit, systemUnit, toSystem);
            this.type = type;
        }

        private Fallback(Fallback<Q> origin, double value) {
            super(origin, value);
            this.type = origin.type;
        }

        @Override
        Quantity<Q> create(double newValue, Unit<Q> newUnit) {
            assert (newUnit == this.getSystemUnit()) : newUnit;
            Fallback<Q> quantity = new Fallback<Q>(this, newValue);
            return (Quantity)Proxy.newProxyInstance(Scalar.class.getClassLoader(), new Class[]{this.type}, quantity);
        }

        static <Q extends Quantity<Q>> Q factory(double value, Unit<Q> unit, Unit<Q> systemUnit, UnitConverter toSystem, Class<Q> type) {
            Fallback<Q> quantity = new Fallback<Q>(value, unit, systemUnit, toSystem, type);
            return (Q)((Quantity)Proxy.newProxyInstance(Scalar.class.getClassLoader(), new Class[]{type}, quantity));
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws ReflectiveOperationException {
            return method.invoke((Object)this, args);
        }
    }

    static final class TemperatureMeasurement
    extends DerivedScalar<Temperature>
    implements Temperature {
        private static final long serialVersionUID = -3901877967613695897L;

        TemperatureMeasurement(double value, Unit<Temperature> unit, Unit<Temperature> systemUnit, UnitConverter toSystem) {
            super(value, unit, systemUnit, toSystem);
        }

        private TemperatureMeasurement(TemperatureMeasurement origin, double value) {
            super(origin, value);
        }

        @Override
        Quantity<Temperature> create(double newValue, Unit<Temperature> newUnit) {
            assert (newUnit == this.getSystemUnit()) : newUnit;
            return new TemperatureMeasurement(this, newValue);
        }
    }
}

