/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.process.traversal.GremlinTypeErrorException;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.PBiPredicate;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class AndP<V>
extends ConnectiveP<V> {
    public AndP(List<P<V>> predicates) {
        super(predicates);
        for (P<V> p : predicates) {
            this.and(p);
        }
        this.biPredicate = new AndBiPredicate(this);
    }

    @Override
    public P<V> and(Predicate<? super V> predicate) {
        if (!(predicate instanceof P)) {
            throw new IllegalArgumentException("Only P predicates can be and'd together");
        }
        if (predicate instanceof AndP) {
            this.predicates.addAll(((AndP)predicate).getPredicates());
        } else {
            this.predicates.add((P)predicate);
        }
        return this;
    }

    @Override
    public P<V> negate() {
        super.negate();
        return new OrP(this.predicates);
    }

    @Override
    public String toString() {
        return "and(" + StringFactory.removeEndBrackets(this.predicates) + ")";
    }

    @Override
    public AndP<V> clone() {
        AndP clone = (AndP)super.clone();
        clone.biPredicate = new AndBiPredicate(clone);
        return clone;
    }

    private class AndBiPredicate
    implements PBiPredicate<V, V>,
    Serializable {
        private final AndP<V> andP;

        private AndBiPredicate(AndP<V> andP2) {
            this.andP = andP2;
        }

        @Override
        public boolean test(V valueA, V valueB) {
            GremlinTypeErrorException typeError = null;
            for (P predicate : this.andP.predicates) {
                try {
                    if (predicate.test(valueA)) continue;
                    return false;
                }
                catch (GremlinTypeErrorException ex) {
                    typeError = ex;
                }
            }
            if (typeError != null) {
                throw typeError;
            }
            return true;
        }

        @Override
        public String getPredicateName() {
            return "and";
        }
    }
}

