/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.legacyapi;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.smallrye.metrics.legacyapi.MeterHolder;
import io.smallrye.metrics.legacyapi.MetricDescriptor;
import io.smallrye.metrics.legacyapi.MpMetadata;
import java.util.HashSet;
import java.util.function.ToDoubleFunction;
import org.eclipse.microprofile.metrics.Counter;

class FunctionCounterAdapter<T>
implements Counter,
MeterHolder {
    FunctionCounter globalCompositeFunctionCounter;
    final T obj;
    final ToDoubleFunction<T> function;

    public FunctionCounterAdapter(T obj, ToDoubleFunction<T> function) {
        this.obj = obj;
        this.function = function;
    }

    public FunctionCounterAdapter<T> register(MpMetadata metadata, MetricDescriptor descriptor, MeterRegistry registry, String scope, Tag ... globalTags) {
        if (this.globalCompositeFunctionCounter == null || metadata.cleanDirtyMetadata()) {
            HashSet<Tag> tagsSet = new HashSet<Tag>();
            for (Tag t : descriptor.tags()) {
                tagsSet.add(t);
            }
            if (globalTags != null) {
                for (Tag t : globalTags) {
                    tagsSet.add(t);
                }
            }
            tagsSet.add(Tag.of((String)"mp_scope", (String)scope));
            this.globalCompositeFunctionCounter = FunctionCounter.builder((String)descriptor.name, this.obj, obj -> this.function.applyAsDouble(obj)).description(metadata.getDescription()).baseUnit(metadata.getUnit()).tags(tagsSet).register((MeterRegistry)Metrics.globalRegistry);
        }
        return this;
    }

    public void inc() {
        throw new UnsupportedOperationException("Method must not be called");
    }

    public void inc(long l) {
        throw new UnsupportedOperationException("Method must not be called");
    }

    public long getCount() {
        return (long)this.globalCompositeFunctionCounter.count();
    }

    @Override
    public Meter getMeter() {
        return this.globalCompositeFunctionCounter;
    }
}

