/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

public class EntityPartImpl
implements EntityPart {
    private final String name;
    private final String fileName;
    private final Object content;
    private final MultivaluedMap<String, String> headers;
    private final MediaType mediaType;
    private final GenericType<?> genericType;
    private final Class<?> type;
    private final Providers providers;

    public EntityPartImpl(Providers providers, String name, String fileName, Object content, Class<?> type, GenericType<?> genericType, MultivaluedMap<String, String> headers, MediaType mediaType) {
        this.providers = providers;
        this.name = name;
        this.fileName = fileName;
        this.content = content;
        this.headers = headers;
        this.mediaType = mediaType;
        this.genericType = genericType;
        this.type = type == null ? (content != null ? content.getClass() : InputStream.class) : type;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getFileName() {
        return Optional.ofNullable(this.fileName);
    }

    public InputStream getContent() {
        try {
            if (this.content instanceof InputStream) {
                return (InputStream)this.content;
            }
            if (this.content instanceof byte[]) {
                return new ByteArrayInputStream((byte[])this.content);
            }
            if (this.fileName != null && !this.fileName.isBlank()) {
                return Files.newInputStream(Path.of(this.fileName, new String[0]), new OpenOption[0]);
            }
            return this.contentAsStream();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private <T> InputStream contentAsStream() throws IOException {
        MediaType mt;
        Type generic = this.genericType != null ? this.genericType.getType() : null;
        MessageBodyWriter writer = this.providers.getMessageBodyWriter(this.type, generic, null, mt = Objects.requireNonNullElse(this.mediaType, MediaType.APPLICATION_OCTET_STREAM_TYPE));
        if (writer == null) {
            throw new IllegalArgumentException("No suitable MessageBodyWriter available to handle " + this.type.getName() + ", media type " + this.mediaType);
        }
        PipedInputStream pipedInputStream = new PipedInputStream();
        try (PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);){
            writer.writeTo(this.content, this.type, generic, null, mt, EntityPartImpl.cast(this.headers), (OutputStream)pipedOutputStream);
            PipedInputStream pipedInputStream2 = pipedInputStream;
            return pipedInputStream2;
        }
    }

    public <T> T getContent(Class<T> asType) throws IllegalArgumentException, IllegalStateException, IOException, WebApplicationException {
        if (asType == null) {
            throw new NullPointerException("The type is required");
        }
        if (asType.isInstance(this.content)) {
            return (T)this.content;
        }
        MessageBodyReader reader = this.providers.getMessageBodyReader(asType, null, null, this.mediaType);
        if (reader != null) {
            try (InputStream is = this.getContent();){
                Object object = reader.readFrom(asType, null, null, this.mediaType, this.headers, is);
                return (T)object;
            }
        }
        throw new IllegalArgumentException("No suitable MessageBodyReader available to handle " + asType.getName() + ", media type " + this.mediaType);
    }

    public <T> T getContent(GenericType<T> asType) throws IllegalArgumentException, IllegalStateException, IOException, WebApplicationException {
        if (asType == null) {
            throw new NullPointerException("The generic type is required");
        }
        if (asType.getRawType().isInstance(this.content)) {
            return (T)this.content;
        }
        MessageBodyReader reader = this.providers.getMessageBodyReader(asType.getRawType(), asType.getType(), null, this.mediaType);
        if (reader != null) {
            try (InputStream is = this.getContent();){
                Object object = reader.readFrom(asType.getRawType(), asType.getType(), null, this.mediaType, this.headers, is);
                return (T)object;
            }
        }
        throw new IllegalArgumentException("No suitable MessageBodyReader available to handle " + asType.getRawType().getName() + ", media type " + this.mediaType);
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    private static <T, U> MultivaluedMap<T, U> cast(MultivaluedMap<?, ?> p) {
        return p;
    }
}

