/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.model.BigDecimalField;
import org.apache.fulcrum.intake.model.BooleanField;
import org.apache.fulcrum.intake.model.DateStringField;
import org.apache.fulcrum.intake.model.DoubleField;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.FileItemField;
import org.apache.fulcrum.intake.model.FloatField;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.model.IntegerField;
import org.apache.fulcrum.intake.model.LongField;
import org.apache.fulcrum.intake.model.ShortField;
import org.apache.fulcrum.intake.model.StringField;
import org.apache.fulcrum.intake.model.XmlField;

public class FieldAdapter
extends XmlAdapter<XmlField, Field<?>> {
    private static Map<String, FieldCtor> fieldCtors = FieldAdapter.initFieldCtors();

    private static Map<String, FieldCtor> initFieldCtors() {
        fieldCtors = new HashMap<String, FieldCtor>();
        fieldCtors.put("int", new FieldCtor(){

            @Override
            public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
                return new IntegerField(f, g);
            }
        });
        fieldCtors.put("boolean", new FieldCtor(){

            @Override
            public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
                return new BooleanField(f, g);
            }
        });
        fieldCtors.put("String", new FieldCtor(){

            @Override
            public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
                return new StringField(f, g);
            }
        });
        fieldCtors.put("BigDecimal", new FieldCtor(){

            @Override
            public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
                return new BigDecimalField(f, g);
            }
        });
        fieldCtors.put("FileItem", new FieldCtor(){

            @Override
            public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
                return new FileItemField(f, g);
            }
        });
        fieldCtors.put("DateString", new FieldCtor(){

            @Override
            public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
                return new DateStringField(f, g);
            }
        });
        fieldCtors.put("float", new FieldCtor(){

            @Override
            public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
                return new FloatField(f, g);
            }
        });
        fieldCtors.put("double", new FieldCtor(){

            @Override
            public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
                return new DoubleField(f, g);
            }
        });
        fieldCtors.put("short", new FieldCtor(){

            @Override
            public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
                return new ShortField(f, g);
            }
        });
        fieldCtors.put("long", new FieldCtor(){

            @Override
            public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
                return new LongField(f, g);
            }
        });
        fieldCtors.put("custom", new FieldCtor(){

            @Override
            public Field<?> getInstance(XmlField f, Group g) throws IntakeException {
                String fieldClass = f.getFieldClass();
                if (fieldClass != null && fieldClass.indexOf(46) == -1) {
                    fieldClass = "org.apache.fulcrum.intake.model." + fieldClass;
                }
                if (fieldClass != null) {
                    try {
                        Class<?> field = Class.forName(fieldClass);
                        Constructor<?> constructor = field.getConstructor(XmlField.class, Group.class);
                        return (Field)constructor.newInstance(f, g);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IntakeException("Could not load Field class(" + fieldClass + ")", e);
                    }
                    catch (Exception e) {
                        throw new IntakeException("Could not create new instance of Field(" + fieldClass + ")", e);
                    }
                }
                throw new IntakeException("Custom field types must define a fieldClass");
            }
        });
        return fieldCtors;
    }

    public static final Field<?> getInstance(XmlField xmlField, Group xmlGroup) throws IntakeException {
        FieldCtor fieldCtor = null;
        Field<?> field = null;
        String type = xmlField.getType();
        fieldCtor = fieldCtors.get(type);
        if (fieldCtor == null) {
            throw new IntakeException("An Unsupported type has been specified for " + xmlField.getName() + " in group " + xmlGroup.getIntakeGroupName() + " type = " + type);
        }
        field = fieldCtor.getInstance(xmlField, xmlGroup);
        return field;
    }

    public Field<?> unmarshal(XmlField xmlField) throws Exception {
        return FieldAdapter.getInstance(xmlField, xmlField.getGroup());
    }

    public XmlField marshal(Field<?> field) throws Exception {
        XmlField xml = new XmlField();
        return xml;
    }

    protected static interface FieldCtor {
        public Field<?> getInstance(XmlField var1, Group var2) throws IntakeException;
    }
}

