/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.client;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jabsorb.client.ClientError;
import org.jabsorb.client.Session;
import org.jabsorb.client.TransportRegistry;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPSession
implements Session {
    private static final Logger log = LoggerFactory.getLogger(HTTPSession.class);
    protected HttpClient client;
    protected HttpState state;
    protected URI uri;
    static final String JSON_CONTENT_TYPE = "application/json";

    public HTTPSession(URI uri) {
        this.uri = uri;
    }

    public void setState(HttpState state) {
        this.state = state;
    }

    public JSONObject sendAndReceive(JSONObject message) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Sending: " + message.toString(2));
            }
            PostMethod postMethod = new PostMethod(this.uri.toString());
            postMethod.setRequestHeader("Content-Type", "text/plain");
            StringRequestEntity requestEntity = new StringRequestEntity(message.toString(), JSON_CONTENT_TYPE, null);
            postMethod.setRequestEntity((RequestEntity)requestEntity);
            this.http().executeMethod(null, (HttpMethod)postMethod, this.state);
            int statusCode = postMethod.getStatusCode();
            if (statusCode != 200) {
                throw new ClientError("HTTP Status - " + HttpStatus.getStatusText((int)statusCode) + " (" + statusCode + ")");
            }
            JSONTokener tokener = new JSONTokener(postMethod.getResponseBodyAsString());
            Object rawResponseMessage = tokener.nextValue();
            JSONObject responseMessage = (JSONObject)rawResponseMessage;
            if (responseMessage == null) {
                throw new ClientError("Invalid response type - " + rawResponseMessage.getClass());
            }
            return responseMessage;
        }
        catch (HttpException e) {
            throw new ClientError(e);
        }
        catch (IOException e) {
            throw new ClientError(e);
        }
        catch (JSONException e) {
            throw new ClientError(e);
        }
    }

    public HostConfiguration getHostConfiguration() {
        return this.http().getHostConfiguration();
    }

    HttpClient http() {
        if (this.client == null) {
            this.client = new HttpClient();
            if (this.state == null) {
                this.state = new HttpState();
            }
            this.client.setState(this.state);
        }
        return this.client;
    }

    public void close() {
        this.state.clear();
        this.state = null;
    }

    public static void register(TransportRegistry registry) {
        registry.registerTransport("http", new Factory());
    }

    static class Factory
    implements TransportRegistry.SessionFactory {
        Factory() {
        }

        public Session newSession(URI uri) {
            return new HTTPSession(uri);
        }
    }
}

