/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.List;
import java.util.Map;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractStructureAction;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FillAction
extends AbstractStructureAction {
    private Map<StringExpression, RutaExpression> features;
    private TypeExpression structureType;

    public FillAction(TypeExpression structureType, Map<StringExpression, RutaExpression> features) {
        this.structureType = structureType;
        this.features = features;
    }

    @Override
    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotations(stream, null, element.getContainer());
        for (AnnotationFS matchedAnnotation : matchedAnnotations) {
            if (matchedAnnotation == null) {
                return;
            }
            Type type = this.getStructureType().getType(element.getParent());
            List<AnnotationFS> list = stream.getAnnotationsInWindow(matchedAnnotation, type);
            if (list.isEmpty()) {
                list = stream.getOverappingAnnotations(matchedAnnotation, type);
            }
            if (list.isEmpty()) continue;
            AnnotationFS annotationFS = list.get(0);
            stream.getCas().removeFsFromIndexes((FeatureStructure)annotationFS);
            this.fillFeatures((TOP)((Annotation)annotationFS), this.features, matchedAnnotation, element, stream);
            stream.getCas().addFsToIndexes((FeatureStructure)annotationFS);
        }
    }

    public Map<StringExpression, RutaExpression> getFeatures() {
        return this.features;
    }

    public TypeExpression getStructureType() {
        return this.structureType;
    }
}

