/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.core.codeassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.ruta.ide.core.codeassist.RutaSelectionParser;
import org.apache.uima.ruta.ide.core.parser.RutaParseUtils;
import org.apache.uima.ruta.ide.parser.ast.RutaImportStatement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;

public class RutaSelectionEngine
extends ScriptSelectionEngine {
    public static boolean DEBUG = DLTKCore.DEBUG_SELECTION;
    protected int actualSelectionStart;
    protected int actualSelectionEnd;
    protected List selectionElements = new ArrayList();
    protected RutaSelectionParser parser = new RutaSelectionParser();
    protected ISourceModule sourceModule;
    protected IDLTKLanguageToolkit toolkit;

    public IModelElement[] select(IModuleSource module, int offset, int i) {
        ArrayList results;
        block2: {
            this.sourceModule = (ISourceModule)module.getModelElement();
            ModuleDeclaration moduleDeclaration = this.parser.parse(module);
            results = new ArrayList();
            try {
                moduleDeclaration.traverse((ASTVisitor)new ModelElementFinder(offset, results, module.getFileName()));
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return results.toArray(new IModelElement[results.size()]);
    }

    protected boolean checkSelection(String source, int selectionSourceStart, int selectionSourceEnd) {
        boolean cheat = false;
        if (selectionSourceEnd < selectionSourceStart) {
            selectionSourceEnd = selectionSourceStart;
            cheat = true;
        }
        int start = RutaParseUtils.startLineOrNoSymbol(selectionSourceStart, source);
        int end = RutaParseUtils.endLineOrNoSymbol(selectionSourceEnd, source);
        if (end <= start) {
            if (cheat) {
                return this.checkSelection(source, selectionSourceEnd - 1, selectionSourceEnd - 1);
            }
            return false;
        }
        if (start > source.length() || end > source.length()) {
            if (cheat) {
                return this.checkSelection(source, selectionSourceEnd - 1, selectionSourceEnd - 1);
            }
            return false;
        }
        String sub = source.substring(start, end);
        if (sub.indexOf(32) != -1 || sub.indexOf(9) != -1 || sub.indexOf(10) != -1) {
            if (cheat) {
                return this.checkSelection(source, selectionSourceEnd - 1, selectionSourceEnd - 1);
            }
            return false;
        }
        this.actualSelectionStart = start;
        this.actualSelectionEnd = end;
        return true;
    }

    private class ModelElementFinder
    extends ASTVisitor {
        private int offset;
        private List results;
        private Set<String> engines;
        private Set<String> typesystems;
        private Map<String, ISourceModule> scripts;
        private Map<String, IField> impFields;
        private String curFileName;

        public ModelElementFinder(int offset, List results, String curFileName) {
            this.offset = offset;
            this.results = results;
            this.engines = new HashSet<String>();
            this.typesystems = new HashSet<String>();
            this.scripts = new HashMap<String, ISourceModule>();
            this.impFields = new HashMap<String, IField>();
            this.curFileName = curFileName;
            try {
                this.importScript(this.parseFileName(curFileName));
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        private String parseFileName(String curFileName2) {
            int i = curFileName2.indexOf("script");
            String s = curFileName2.substring(i + "scripts".length() - 1);
            if ((s = s.replace('/', '.')).endsWith(".ruta")) {
                s = s.substring(1, s.length() - 5);
            }
            return s;
        }

        public boolean visit(Statement s) throws Exception {
            if (s instanceof RutaImportStatement) {
                SimpleReference sRef;
                if (((RutaImportStatement)s).getType() == 9) {
                    sRef = (SimpleReference)((RutaImportStatement)s).getExpression();
                    this.importEngine(sRef.getName());
                }
                if (((RutaImportStatement)s).getType() == 9) {
                    sRef = (SimpleReference)((RutaImportStatement)s).getExpression();
                    this.importEngine(sRef.getName());
                }
                if (((RutaImportStatement)s).getType() == 5) {
                    this.importScript(s);
                }
                if (((RutaImportStatement)s).getType() == 3) {
                    this.importTypesystem(s);
                }
                return false;
            }
            return true;
        }

        public boolean visit(Expression s) throws Exception {
            if (s.sourceStart() <= this.offset && this.offset <= s.sourceEnd()) {
                SimpleReference sr;
                String name;
                if (s instanceof VariableReference) {
                    VariableReference ref = (VariableReference)s;
                    name = ((VariableReference)s).getName();
                    this.findLocalDeclaration(name, this.results, IField.class);
                    if (this.impFields.containsKey(name)) {
                        this.results.add(this.impFields.get(name));
                    }
                }
                if (s != null && s.getKind() == 10021 && (sr = (SimpleReference)s.getChilds().get(0)) != null && !this.engines.contains(name = sr.getName())) {
                    if (this.scripts.containsKey(name)) {
                        this.findImportedDeclaration(name, this.results, IMethod.class);
                    } else {
                        this.checkInnerBlockRef(name, "");
                        name = name.substring(name.lastIndexOf(46) + 1);
                        this.findLocalDeclaration(name, this.results, IMethod.class);
                    }
                }
            }
            return super.visit(s);
        }

        public boolean visit(MethodDeclaration s) throws Exception {
            if (s.getNameStart() <= this.offset && this.offset <= s.getNameEnd()) {
                this.findLocalDeclaration(s.getName(), this.results, IMethod.class);
            }
            return super.visit(s);
        }

        public boolean visit(TypeDeclaration s) throws Exception {
            if (s.getNameStart() <= this.offset && this.offset <= s.getNameEnd()) {
                this.findLocalDeclaration(s.getName(), this.results, IField.class);
            }
            return super.visit(s);
        }

        private void checkInnerBlockRef(String head, String tail) {
            int li = head.lastIndexOf(46);
            if (li > 0) {
                String frontPart = head.substring(0, li);
                if (StringUtils.isEmpty((CharSequence)tail)) {
                    tail = head.substring(li + 1);
                }
                if (this.scripts.containsKey(frontPart)) {
                    this.findDeclaration(this.scripts.get(frontPart), tail, this.results, IMethod.class);
                } else {
                    this.checkInnerBlockRef(frontPart, tail);
                }
            }
        }

        private void importEngine(String name) {
            String lastPart;
            this.engines.add(name);
            int i = name.lastIndexOf(46);
            if (i > 1 && (lastPart = name.substring(i + 1)) != null && lastPart.length() != 0) {
                this.engines.add(lastPart);
            }
        }

        public IFile getFile(IFolder folder, String filePath) {
            int lastDot = filePath.lastIndexOf(46);
            int sndLastDot = filePath.lastIndexOf(46, lastDot - 1);
            String fName = filePath;
            if (sndLastDot >= 0) {
                String subFolder = filePath.substring(0, sndLastDot);
                folder = folder.getFolder(subFolder);
                fName = filePath.substring(sndLastDot + 1);
            }
            return folder.getFile(fName);
        }

        private void importScript(Statement s) throws ModelException {
            SimpleReference sRef = (SimpleReference)((RutaImportStatement)s).getExpression();
            String sRefName = sRef.getName();
            this.importScript(sRefName);
        }

        private void importTypesystem(Statement s) {
            SimpleReference sRef = (SimpleReference)((RutaImportStatement)s).getExpression();
        }

        private void importScript(String sRefName) throws ModelException {
            int lastDot = sRefName.lastIndexOf(46);
            String fileNameShort = sRefName.substring(lastDot + 1);
            String fileName = fileNameShort + ".ruta";
            ISourceModule sm = null;
            IScriptFolder[] scriptFolders = RutaSelectionEngine.this.sourceModule.getScriptProject().getScriptFolders();
            for (int i = 0; i < scriptFolders.length; ++i) {
                sm = scriptFolders[i].getSourceModule(fileName);
                if (!sm.exists() || sm.getResource() == null || !sm.getResource().exists()) continue;
                this.scripts.put(sRefName, sm);
                this.scripts.put(fileNameShort, sm);
                this.importFields(sm.getFields());
                break;
            }
        }

        private void importFields(IField[] fields) {
            if (fields == null) {
                return;
            }
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i] == null) continue;
                IField iField = fields[i];
                IPath path = iField.getPath();
                String fullyQualifiedName = this.parseFileName(path.toString());
                this.impFields.put(iField.getElementName(), iField);
                this.impFields.put(fullyQualifiedName + "." + iField.getElementName(), iField);
            }
        }

        private void findImportedDeclaration(String name, List results, Class type) {
            ISourceModule module = this.scripts.get(name);
            if (module != null && module.exists()) {
                results.add(module);
            }
        }

        private void findDeclaration(ISourceModule sm, final String name, final List results, final Class type) {
            block2: {
                try {
                    sm.accept(new IModelElementVisitor(){

                        public boolean visit(IModelElement element) {
                            Class<?> e = element.getClass();
                            boolean classCheck = type.isAssignableFrom(e);
                            if (element.getElementName().equals(name) && classCheck) {
                                results.add(element);
                                return false;
                            }
                            return true;
                        }
                    });
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block2;
                    e.printStackTrace();
                }
            }
        }

        private void findLocalDeclaration(final String name, final List results, final Class type) {
            block2: {
                try {
                    RutaSelectionEngine.this.sourceModule.accept(new IModelElementVisitor(){

                        public boolean visit(IModelElement element) {
                            Class<?> e = element.getClass();
                            boolean classCheck = type.isAssignableFrom(e);
                            if (element.getElementName().equals(name) && classCheck) {
                                results.add(element);
                            }
                            return true;
                        }
                    });
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block2;
                    e.printStackTrace();
                }
            }
        }
    }
}

