/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.charcode;

import net.sf.saxon.charcode.CharacterSet;

public final class UnicodeCharacterSet
implements CharacterSet {
    private static UnicodeCharacterSet theInstance = new UnicodeCharacterSet();

    private UnicodeCharacterSet() {
    }

    public static UnicodeCharacterSet getInstance() {
        return theInstance;
    }

    public boolean inCharset(int n) {
        return true;
    }

    public static int getUTF8Encoding(char c, char c2, byte[] byArray) {
        char c3 = c;
        if (c3 <= '\u007f') {
            byArray[0] = (byte)c3;
            return 1;
        }
        if (c3 <= '\u07ff') {
            byArray[0] = (byte)(0xC0 | c >> 6 & 0x1F);
            byArray[1] = (byte)(0x80 | c & 0x3F);
            return 2;
        }
        if (c3 >= '\ud800' && c3 <= '\udbff') {
            char c4 = c2;
            if (c4 < '\udc00' || c4 > '\udfff') {
                throw new IllegalArgumentException("Malformed Unicode Surrogate Pair (" + c3 + ',' + c4 + ')');
            }
            byte by = (byte)(c4 & 0x3F);
            byte by2 = (byte)((c3 & 3) << 4 | c4 >> 6 & 0xF);
            byte by3 = (byte)(c3 >> 2 & 0xF);
            byte by4 = (byte)((c3 >> 6 & 0xF) + 1);
            byArray[0] = (byte)(0xF0 | by4 >> 2 & 7);
            byArray[1] = (byte)(0x80 | (by4 & 3) << 4 | by3);
            byArray[2] = (byte)(0x80 | by2);
            byArray[3] = (byte)(0x80 | by);
            return 4;
        }
        if (c3 >= '\udc00' && c3 <= '\udfff') {
            return 0;
        }
        byArray[0] = (byte)(0xE0 | c >> 12 & 0xF);
        byArray[1] = (byte)(0x80 | c >> 6 & 0x3F);
        byArray[2] = (byte)(0x80 | c & 0x3F);
        return 3;
    }

    public static int decodeUTF8(byte[] byArray, int n) throws IllegalArgumentException {
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            if ((byArray[i] & 0xC0) != 128) {
                throw new IllegalArgumentException("Byte " + (i + 1) + " in UTF-8 sequence has wrong top bits");
            }
            n2 = (n2 << 6) + (byArray[i] & 0x3F);
        }
        if ((byArray[0] & 0x80) == 0) {
            if (n == 1) {
                return byArray[0];
            }
            throw new IllegalArgumentException("UTF8 single byte expected");
        }
        if ((byArray[0] & 0xE0) == 192) {
            if (n != 2) {
                throw new IllegalArgumentException("UTF8 sequence of two bytes expected");
            }
            return ((byArray[0] & 0x1F) << 6) + n2;
        }
        if ((byArray[0] & 0xF0) == 224) {
            if (n != 3) {
                throw new IllegalArgumentException("UTF8 sequence of three bytes expected");
            }
            return ((byArray[0] & 0xF) << 12) + n2;
        }
        if ((byArray[0] & 0xF8) == 248) {
            if (n != 4) {
                throw new IllegalArgumentException("UTF8 sequence of four bytes expected");
            }
            return ((byArray[0] & 7) << 24) + n2;
        }
        throw new IllegalArgumentException("UTF8 invalid first byte");
    }
}

