/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.sort.CollationURIResolver;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public class StandardCollationURIResolver
implements CollationURIResolver {
    private static final StandardCollationURIResolver theInstance = new StandardCollationURIResolver();

    private StandardCollationURIResolver() {
    }

    public static final StandardCollationURIResolver getInstance() {
        return theInstance;
    }

    public StringCollator resolve(String string, String string2, Configuration configuration) {
        try {
            if (string.equals("http://saxon.sf.net/collation")) {
                return Configuration.getPlatform().makeCollation(configuration, new Properties(), string);
            }
            if (string.startsWith("http://saxon.sf.net/collation?")) {
                URI uRI;
                try {
                    uRI = new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new DynamicError(uRISyntaxException);
                }
                Properties properties = new Properties();
                String string3 = uRI.getQuery();
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ";&");
                while (stringTokenizer.hasMoreElements()) {
                    String string4 = stringTokenizer.nextToken();
                    int n = string4.indexOf(61);
                    if (n <= 0 || n >= string4.length() - 1) continue;
                    String string5 = string4.substring(0, n);
                    String string6 = string4.substring(n + 1);
                    properties.setProperty(string5, string6);
                }
                return Configuration.getPlatform().makeCollation(configuration, properties, string);
            }
            return null;
        }
        catch (XPathException xPathException) {
            try {
                configuration.getErrorListener().warning(xPathException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            return null;
        }
    }
}

