/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.admin.LinearTypeOrder;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.LinearTypeOrderBuilderImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.internal.util.IntVector;

public class FSIndexComparatorImpl
implements FSIndexComparator {
    private Type type;
    private final List<Object> keySpecs;
    private final IntVector directions;

    public FSIndexComparatorImpl() {
        this.type = null;
        this.keySpecs = new ArrayList<Object>();
        this.directions = new IntVector();
    }

    private FSIndexComparatorImpl(Type type, List<Object> keySpecs, IntVector directions) {
        this.type = type;
        this.keySpecs = keySpecs;
        this.directions = directions;
    }

    private boolean checkType(Type t) {
        return t.isPrimitive();
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    int getTypeCode() {
        return ((TypeImpl)this.type).getCode();
    }

    @Override
    public int addKey(Feature feat, int compareKey) {
        if (!this.checkType(feat.getRange())) {
            return -1;
        }
        int rc = this.keySpecs.size();
        this.keySpecs.add(feat);
        this.directions.add(compareKey);
        return rc;
    }

    @Override
    public int addKey(LinearTypeOrder typeOrder, int compareKey) {
        int rc = this.keySpecs.size();
        this.keySpecs.add(typeOrder);
        this.directions.add(compareKey);
        return rc;
    }

    @Override
    public int getKeyType(int key) {
        return this.keySpecs.get(key) instanceof Feature ? 0 : 1;
    }

    @Override
    public int getNumberOfKeys() {
        return this.keySpecs.size();
    }

    @Override
    public FeatureImpl getKeyFeature(int key) {
        if (this.getKeyType(key) == 0) {
            return (FeatureImpl)this.keySpecs.get(key);
        }
        return null;
    }

    public LinearTypeOrder getKeyTypeOrder(int key) {
        if (this.getKeyType(key) == 1) {
            return (LinearTypeOrder)this.keySpecs.get(key);
        }
        return null;
    }

    @Override
    public int getKeyComparator(int key) {
        return this.directions.get(key);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FSIndexComparatorImpl)) {
            return false;
        }
        FSIndexComparatorImpl comp = (FSIndexComparatorImpl)o;
        if (this.type != comp.type) {
            return false;
        }
        return this.equalsWithoutType(comp);
    }

    boolean equalsWithoutType(FSIndexComparatorImpl comp) {
        int max = this.getNumberOfKeys();
        if (max != comp.getNumberOfKeys()) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            boolean featimpl_match;
            Object keySpec1 = this.keySpecs.get(i);
            Object keySpec2 = comp.keySpecs.get(i);
            if (keySpec1 instanceof LinearTypeOrder) {
                if (((LinearTypeOrder)keySpec1).equals((LinearTypeOrder)keySpec2)) continue;
                return false;
            }
            FeatureImpl f1 = (FeatureImpl)keySpec1;
            FeatureImpl f2 = (FeatureImpl)keySpec2;
            boolean bl = featimpl_match = f1.equals(f2) && f1.getOffset() == f2.getOffset() && f1.getAdjustedOffset() == f2.getAdjustedOffset() && this.directions.get(i) == comp.directions.get(i);
            if (featimpl_match) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 31 : this.type.hashCode());
        int max = this.getNumberOfKeys();
        for (int i = 0; i < max; ++i) {
            Object o = this.keySpecs.get(i);
            if (o instanceof LinearTypeOrder) {
                result = 31 * result + ((LinearTypeOrderBuilderImpl.TotalTypeOrder)o).hashCode();
                continue;
            }
            FeatureImpl f = (FeatureImpl)o;
            result = 31 * result + f.hashCode();
            result = 31 * result + f.getOffset();
            result = 31 * result + f.getAdjustedOffset();
            result = 31 * result + this.directions.get(i);
        }
        return result;
    }

    @Override
    public boolean isValid() {
        if (this.type == null) {
            return false;
        }
        int max = this.getNumberOfKeys();
        for (int i = 0; i < max; ++i) {
            Feature feat;
            if (this.getKeyType(i) != 0 || ((TypeImpl)(feat = (Feature)this.keySpecs.get(i)).getDomain()).subsumes((TypeImpl)this.type)) continue;
            return false;
        }
        return true;
    }

    public synchronized FSIndexComparatorImpl copy() {
        return new FSIndexComparatorImpl(this.type, this.keySpecs, this.directions);
    }

    @Override
    public int compareTo(FSIndexComparator o) {
        FSIndexComparator comp = o;
        int thisSize = this.getNumberOfKeys();
        int compSize = comp.getNumberOfKeys();
        int i = 0;
        while (i < thisSize && i < compSize) {
            int feat2;
            int feat1 = this.getKeyFeature(i).getCode();
            if (feat1 < (feat2 = ((FeatureImpl)comp.getKeyFeature(i)).getCode())) {
                return -1;
            }
            if (feat1 > feat2) {
                return 1;
            }
            if (this.getKeyComparator(i) < comp.getKeyComparator(i)) {
                return -1;
            }
            if (this.getKeyComparator(i) <= comp.getKeyComparator(i)) continue;
            return 1;
        }
        if (i < thisSize) {
            return 1;
        }
        if (i < compSize) {
            return -1;
        }
        return 0;
    }
}

