/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.nio.ByteBuffer;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FutureObjects;
import org.elasticsearch.common.bytes.BytesReference;

public class ByteBufferReference
extends BytesReference {
    private final ByteBuffer buffer;
    private final int length;

    ByteBufferReference(ByteBuffer buffer) {
        this.buffer = buffer.slice();
        this.length = buffer.remaining();
    }

    @Override
    public byte get(int index) {
        return this.buffer.get(index);
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public BytesReference slice(int from, int length) {
        FutureObjects.checkFromIndexSize((int)from, (int)length, (int)this.length);
        this.buffer.position(from);
        this.buffer.limit(from + length);
        ByteBufferReference newByteBuffer = new ByteBufferReference(this.buffer);
        this.buffer.position(0);
        this.buffer.limit(this.length);
        return newByteBuffer;
    }

    @Override
    public BytesRef toBytesRef() {
        if (this.buffer.hasArray()) {
            return new BytesRef(this.buffer.array(), this.buffer.arrayOffset(), this.length);
        }
        byte[] copy = new byte[this.length];
        this.buffer.get(copy, 0, this.length);
        return new BytesRef(copy);
    }

    @Override
    public long ramBytesUsed() {
        return this.buffer.capacity();
    }
}

