/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.AbstractJsonValidator;
import com.networknt.schema.CustomErrorMessageType;
import com.networknt.schema.ValidationMessage;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.unomi.api.services.ScopeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopeValidator
extends AbstractJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(ScopeValidator.class);
    private ScopeService scopeService;

    public ScopeValidator(ScopeService scopeService) {
        super("validateScope");
        this.scopeService = scopeService;
    }

    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        if (logger.isDebugEnabled()) {
            logger.debug("validate( {}, {}, {})", new Object[]{node, rootNode, at});
        }
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        if (this.scopeService.getScope(node.textValue()) == null) {
            errors.add(this.buildValidationMessage(CustomErrorMessageType.of((String)"1100", (MessageFormat)new MessageFormat("Unknown scope value at \"{0}\" for value {1}")), at, new String[]{node.textValue()}));
        }
        return errors;
    }
}

