/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.SelectorUtils;

public class DirectoryScanner {
    private Path basedir;
    private List<String> includePatterns;
    private boolean caseSensitive = OsUtils.isUNIX();

    public DirectoryScanner() {
    }

    public DirectoryScanner(Path dir) {
        this(dir, Collections.emptyList());
    }

    public DirectoryScanner(Path dir, String ... includes) {
        this(dir, GenericUtils.isEmpty(includes) ? Collections.emptyList() : Arrays.asList(includes));
    }

    public DirectoryScanner(Path dir, Collection<String> includes) {
        this.setBasedir(dir);
        this.setIncludes(includes);
    }

    public void setBasedir(Path basedir) {
        this.basedir = basedir;
    }

    public Path getBasedir() {
        return this.basedir;
    }

    public void setIncludes(String ... includes) {
        this.setIncludes(GenericUtils.isEmpty(includes) ? Collections.emptyList() : Arrays.asList(includes));
    }

    public List<String> getIncludes() {
        return this.includePatterns;
    }

    public void setIncludes(Collection<String> includes) {
        this.includePatterns = GenericUtils.isEmpty(includes) ? Collections.emptyList() : Collections.unmodifiableList(includes.stream().map(v -> DirectoryScanner.normalizePattern(v)).collect(Collectors.toCollection(() -> new ArrayList(includes.size()))));
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Collection<Path> scan() throws IOException, IllegalStateException {
        return this.scan(LinkedList::new);
    }

    public <C extends Collection<Path>> C scan(Supplier<? extends C> factory) throws IOException, IllegalStateException {
        Path dir = this.getBasedir();
        if (dir == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (!Files.exists(dir, new LinkOption[0])) {
            throw new IllegalStateException("basedir " + dir + " does not exist");
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IllegalStateException("basedir " + dir + " is not a directory");
        }
        if (GenericUtils.isEmpty(this.getIncludes())) {
            throw new IllegalStateException("No includes set for " + dir);
        }
        return (C)this.scandir(dir, dir, (Collection)factory.get());
    }

    protected <C extends Collection<Path>> C scandir(Path rootDir, Path dir, C filesList) throws IOException {
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(dir);){
            for (Path p : ds) {
                Path rel = rootDir.relativize(p);
                String name = rel.toString();
                if (Files.isDirectory(p, new LinkOption[0])) {
                    if (this.isIncluded(name)) {
                        filesList.add((Path)p);
                        this.scandir(rootDir, p, filesList);
                        continue;
                    }
                    if (!this.couldHoldIncluded(name)) continue;
                    this.scandir(rootDir, p, filesList);
                    continue;
                }
                if (!Files.isRegularFile(p, new LinkOption[0]) || !this.isIncluded(name)) continue;
                filesList.add((Path)p);
            }
        }
        return filesList;
    }

    protected boolean isIncluded(String name) {
        List<String> includes = this.getIncludes();
        if (GenericUtils.isEmpty(includes)) {
            return false;
        }
        boolean cs = this.isCaseSensitive();
        for (String include : includes) {
            if (!SelectorUtils.matchPath(include, name, cs)) continue;
            return true;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String name) {
        List<String> includes = this.getIncludes();
        if (GenericUtils.isEmpty(includes)) {
            return false;
        }
        boolean cs = this.isCaseSensitive();
        for (String include : includes) {
            if (!SelectorUtils.matchPatternStart(include, name, cs)) continue;
            return true;
        }
        return false;
    }

    public static String normalizePattern(String pattern) {
        if ((pattern = pattern.trim()).startsWith("%regex[")) {
            pattern = File.separatorChar == '\\' ? DirectoryScanner.replace(pattern, "/", "\\\\", -1) : DirectoryScanner.replace(pattern, "\\\\", "/", -1);
        } else if ((pattern = pattern.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar)).endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    public static String replace(String text, String repl, String with, int max) {
        if (text == null || repl == null || with == null || repl.length() == 0) {
            return text;
        }
        int start = 0;
        StringBuilder buf = new StringBuilder(text.length());
        int end = text.indexOf(repl, start);
        while (end != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max == 0) break;
            end = text.indexOf(repl, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }
}

