/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.plugins.DataLoader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/com/intellij/ide/plugins/LocalFsDataLoader;", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/DataLoader;", "basePath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "emptyDescriptorIfCannotResolve", "", "getEmptyDescriptorIfCannotResolve", "()Z", "load", "Ljava/io/InputStream;", "path", "", "pluginDescriptorSourceOnly", "toString", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class LocalFsDataLoader
implements DataLoader {
    @JvmField
    @NotNull
    public final Path basePath;

    public LocalFsDataLoader(@NotNull Path basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.basePath = basePath;
    }

    @Override
    @Nullable
    public InputStream load(@NotNull String path, boolean pluginDescriptorSourceOnly) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            inputStream = Files.newInputStream(this.basePath.resolve(path), new OpenOption[0]);
        }
        catch (NoSuchFileException e2) {
            inputStream = null;
        }
        return inputStream;
    }

    @Override
    @NotNull
    public String toString() {
        return ((Object)this.basePath).toString();
    }
}

