/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.net.URI;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceAccessor;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExternalResourceAccessor
implements ExternalResourceAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExternalResourceAccessor.class);
    private final FileStore<String> fileStore;
    private final CacheAwareExternalResourceAccessor resourceAccessor;

    public DefaultExternalResourceAccessor(FileStore<String> fileStore, CacheAwareExternalResourceAccessor resourceAccessor) {
        this.fileStore = fileStore;
        this.resourceAccessor = resourceAccessor;
    }

    @Override
    public @Nullable LocallyAvailableExternalResource resolveUri(URI uri) {
        return this.resolve(new ExternalResourceName(uri));
    }

    @Override
    public @Nullable LocallyAvailableExternalResource resolveResource(ExternalResourceName resource) {
        return this.resolve(resource);
    }

    private @Nullable LocallyAvailableExternalResource resolve(final ExternalResourceName resource) {
        LOGGER.debug("Loading {}", (Object)resource);
        try {
            return this.resourceAccessor.getResource(resource, null, new CacheAwareExternalResourceAccessor.DefaultResourceFileStore<String>(this.fileStore){

                @Override
                protected String computeKey() {
                    return resource.toString();
                }
            }, null);
        }
        catch (Exception e) {
            throw ResourceExceptions.getFailed((URI)resource.getUri(), (Throwable)e);
        }
    }
}

