/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.merge;

import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.index.merge.MergedSegmentWarmerStats;

@ExperimentalApi
public class MergedSegmentTransferTracker {
    private final CounterMetric totalWarmInvocationsCount = new CounterMetric();
    private final CounterMetric totalWarmTimeMillis = new CounterMetric();
    private final CounterMetric totalWarmFailureCount = new CounterMetric();
    private final CounterMetric totalBytesSent = new CounterMetric();
    private final CounterMetric totalBytesReceived = new CounterMetric();
    private final CounterMetric totalSendTimeMillis = new CounterMetric();
    private final CounterMetric totalReceiveTimeMillis = new CounterMetric();
    private final CounterMetric ongoingWarms = new CounterMetric();

    public void incrementTotalWarmInvocationsCount() {
        this.totalWarmInvocationsCount.inc();
    }

    public void incrementOngoingWarms() {
        this.ongoingWarms.inc();
    }

    public void decrementOngoingWarms() {
        this.ongoingWarms.dec();
    }

    public void incrementTotalWarmFailureCount() {
        this.totalWarmFailureCount.inc();
    }

    public void addTotalWarmTimeMillis(long time) {
        this.totalWarmTimeMillis.inc(time);
    }

    public void addTotalSendTimeMillis(long time) {
        this.totalSendTimeMillis.inc(time);
    }

    public void addTotalReceiveTimeMillis(long time) {
        this.totalReceiveTimeMillis.inc(time);
    }

    public void addTotalBytesSent(long bytes) {
        this.totalBytesSent.inc(bytes);
    }

    public void addTotalBytesReceived(long bytes) {
        this.totalBytesReceived.inc(bytes);
    }

    public MergedSegmentWarmerStats stats() {
        MergedSegmentWarmerStats stats = new MergedSegmentWarmerStats();
        stats.add(this.totalWarmInvocationsCount.count(), this.totalWarmTimeMillis.count(), this.totalWarmFailureCount.count(), this.totalBytesSent.count(), this.totalBytesReceived.count(), this.totalSendTimeMillis.count(), this.totalReceiveTimeMillis.count(), this.ongoingWarms.count());
        return stats;
    }
}

