var __defProp = Object.defineProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });

// src/misc/MultiMap.ts
var MultiMap = class extends Map {
  static {
    __name(this, "MultiMap");
  }
  map(key, value) {
    let elementsForKey = this.get(key);
    if (!elementsForKey) {
      elementsForKey = new Array();
      this.set(key, elementsForKey);
    }
    elementsForKey.push(value);
  }
  getPairs() {
    const pairs = new Array();
    for (const key of this.keys()) {
      const keys = this.get(key) ?? [];
      for (const value of keys) {
        pairs.push([key, value]);
      }
    }
    return pairs;
  }
  toString() {
    const entries = [];
    this.forEach((value, key) => {
      entries.push(`${key}=[${value.join(", ")}]`);
    });
    return `{${entries.join(", ")}}`;
  }
};
export {
  MultiMap
};
